/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.event;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.utils.value.IntValue;
import me.pandamods.fallingtrees.api.TreeHandler;
import me.pandamods.fallingtrees.compat.TreeChopCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EventHandler {
    public static void register() {
        BlockEvent.BREAK.register(EventHandler::onBlockBreak);
    }

    private static EventResult onBlockBreak(Level level, BlockPos blockPos, BlockState blockState, ServerPlayer serverPlayer, IntValue intValue) {
        if (serverPlayer == null) {
            return EventResult.pass();
        }
        if (!TreeHandler.canPlayerChopTree((Player)serverPlayer)) {
            return EventResult.pass();
        }
        if (!TreeChopCompat.isChoppable(level, blockPos) && TreeHandler.destroyTree(level, blockPos, (Player)serverPlayer)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

