/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.registry.TreeRegistry;
import me.pandamods.fallingtrees.utils.BlockMapEntityData;
import me.pandamods.fallingtrees.utils.ItemListEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class TreeEntity
extends Entity {
    public static final EntityDataAccessor<Map<BlockPos, BlockState>> BLOCKS = SynchedEntityData.defineId(TreeEntity.class, BlockMapEntityData.BLOCK_MAP);
    public static final EntityDataAccessor<List<ItemStack>> DROPS = SynchedEntityData.defineId(TreeEntity.class, ItemListEntityData.ITEM_LIST);
    public static final EntityDataAccessor<BlockPos> ORIGIN_POS = SynchedEntityData.defineId(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<Direction> FALL_DIRECTION = SynchedEntityData.defineId(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    public static final EntityDataAccessor<String> TREE_TYPE_LOCATION = SynchedEntityData.defineId(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public Entity owner = null;
    public TreeType treeType = null;

    public TreeEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public void setData(Entity owner, TreeType tree, BlockPos originBlock, List<BlockPos> blockPosList, List<ItemStack> drops) {
        this.owner = owner;
        this.treeType = tree;
        ResourceLocation treeTypeLocation = TreeRegistry.getTreeLocation(tree);
        if (treeTypeLocation != null) {
            this.getEntityData().set(TREE_TYPE_LOCATION, (Object)treeTypeLocation.toString());
        }
        HashMap<BlockPos, BlockState> blockPosMap = new HashMap<BlockPos, BlockState>();
        for (BlockPos pos : blockPosList) {
            blockPosMap.put(pos.immutable().subtract((Vec3i)originBlock), this.level().getBlockState(pos));
        }
        this.getEntityData().set(ORIGIN_POS, (Object)originBlock);
        this.getEntityData().set(BLOCKS, blockPosMap);
        this.getEntityData().set(DROPS, drops);
        this.getEntityData().set(FALL_DIRECTION, (Object)Direction.fromYRot((double)(-Math.toDegrees((double)Math.atan2((double)(owner.getX() - (double)originBlock.getX()), (double)(owner.getZ() - (double)originBlock.getZ()))))).getOpposite());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BLOCKS, Collections.emptyMap());
        builder.define(DROPS, Collections.emptyList());
        builder.define(ORIGIN_POS, (Object)new BlockPos(0, 0, 0));
        builder.define(FALL_DIRECTION, (Object)Direction.NORTH);
        builder.define(TREE_TYPE_LOCATION, (Object)"");
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (TREE_TYPE_LOCATION.equals(dataAccessor)) {
            this.treeType = TreeRegistry.getTree(ResourceLocation.tryParse((String)((String)this.getEntityData().get(TREE_TYPE_LOCATION))));
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public void tick() {
        super.tick();
        this.treeType.onTreeTick(this);
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.5, 1.0));
        }
        if (this.tickCount >= this.getMaxLifeTimeTick()) {
            if (!this.level().isClientSide()) {
                this.dropItems();
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private void dropItems() {
        for (ItemStack stack : (List)this.getEntityData().get(DROPS)) {
            double deltaX = Mth.nextDouble((RandomSource)this.level().random, (double)-0.1, (double)0.1);
            double deltaY = 0.25;
            double deltaZ = Mth.nextDouble((RandomSource)this.level().random, (double)-0.1, (double)0.1);
            ItemEntity entity = new ItemEntity(this.level(), this.getX(), this.getY() + (double)(EntityType.ITEM.getHeight() / 2.0f), this.getZ(), stack, deltaX, deltaY, deltaZ);
            entity.setDefaultPickUpDelay();
            this.level().addFreshEntity((Entity)entity);
        }
    }

    public int getMaxLifeTimeTick() {
        return (int)(FallingTreesConfig.getCommonConfig().treeLifetimeLength * 20.0f);
    }

    public float getLifetime(float partialTick) {
        return ((float)this.tickCount + partialTick) / 20.0f;
    }

    public Map<BlockPos, BlockState> getBlocks() {
        return (Map)this.getEntityData().get(BLOCKS);
    }

    public BlockPos getOriginPos() {
        return (BlockPos)this.getEntityData().get(ORIGIN_POS);
    }

    @NotNull
    public Direction getDirection() {
        return (Direction)this.getEntityData().get(FALL_DIRECTION);
    }

    public TreeType getTreeType() {
        return this.treeType;
    }
}

