/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.api;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.ClientConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.exceptions.TreeException;
import me.pandamods.fallingtrees.registry.EntityRegistry;
import me.pandamods.fallingtrees.registry.TreeRegistry;
import me.pandamods.pandalib.utils.RunUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class TreeHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<UUID, TreeSpeed> TREE_SPEED_CACHES = new ConcurrentHashMap<UUID, TreeSpeed>();

    public static boolean destroyTree(Level level, BlockPos blockPos, Player player) {
        if (level.isClientSide()) {
            return false;
        }
        BlockState blockState = level.getBlockState(blockPos);
        TreeType tree = TreeRegistry.getTree(blockState);
        if (tree == null) {
            return false;
        }
        TreeData data = TreeHandler.tryGatherTreeData(tree, blockPos, level, player, false);
        if (data == null) {
            return false;
        }
        List<BlockPos> blocks = data.blocks();
        TreeEntity entity = new TreeEntity((EntityType)EntityRegistry.TREE.get(), level);
        entity.setPos((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5);
        entity.setData((Entity)player, tree, blockPos, blocks, data.drops());
        player.causeFoodExhaustion(FallingTreesConfig.getCommonConfig().disableExtraFoodExhaustion ? 1.0f : data.foodExhaustionModifier().getExhaustion(0.005f));
        if (player.getMainHandItem().isDamageableItem()) {
            player.getMainHandItem().hurtAndBreak(FallingTreesConfig.getCommonConfig().disableExtraToolDamage ? 1 : data.toolDamage(), (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)player.getMainHandItem().getItem()));
        data.awardedStats().forEach(awardedStat -> player.awardStat(awardedStat.stat(), awardedStat.amount()));
        HashMap<BlockPos, BlockState> blockStates = new HashMap<BlockPos, BlockState>();
        BlockState air = Blocks.AIR.defaultBlockState();
        for (BlockPos pos2 : blocks) {
            BlockState oldState2 = level.getBlockState(pos2);
            level.setBlock(pos2, air, 16);
            level.setBlocksDirty(pos2, oldState2, level.getBlockState(pos2));
            blockStates.put(pos2, oldState2);
        }
        blockStates.forEach((pos, oldState) -> {
            BlockState newState = level.getBlockState(pos);
            level.sendBlockUpdated(pos, oldState, newState, 3);
            level.sendBlockUpdated(pos, oldState, newState, 3);
            level.blockUpdated(pos, newState.getBlock());
            newState.updateIndirectNeighbourShapes((LevelAccessor)level, pos, 511);
            oldState.updateNeighbourShapes((LevelAccessor)level, pos, 511);
            oldState.updateIndirectNeighbourShapes((LevelAccessor)level, pos, 511);
            level.onBlockStateChange(pos, oldState, newState);
        });
        level.addFreshEntity((Entity)entity);
        return true;
    }

    public static TreeData tryGatherTreeData(TreeType treeType, BlockPos blockPos, Level level, Player player, boolean ignoreExceptions) {
        block4: {
            try {
                return treeType.gatherTreeData(blockPos, level, player);
            }
            catch (TreeException e) {
                if (!ignoreExceptions) {
                    LOGGER.warn(e.getMessage());
                }
            }
            catch (Exception e) {
                if (ignoreExceptions) break block4;
                LOGGER.error("An error occurred when trying to gather tree data", (Throwable)e);
                player.displayClientMessage((Component)Component.literal((String)("Error: " + String.valueOf(e))).withStyle(Style.EMPTY.withColor(Color.red.getRGB())), false);
                player.displayClientMessage((Component)Component.translatable((String)"text.fallingtrees.tree_handler.exception.1").withStyle(Style.EMPTY.withColor(Color.red.getRGB())), false);
                player.displayClientMessage((Component)Component.translatable((String)"text.fallingtrees.tree_handler.exception.2").withStyle(Style.EMPTY.withColor(Color.red.getRGB())), false);
            }
        }
        return null;
    }

    public static boolean canPlayerChopTree(Player player) {
        ClientConfig clientConfig = FallingTreesConfig.getClientConfig(player);
        if (clientConfig == null) {
            RunUtil.runOnce((String)("falling_trees_player_client_config_missing_" + String.valueOf(player.getUUID())), () -> LOGGER.warn("Couldn't find client config for player: {} [{}]", (Object)player.getDisplayName().getString(), (Object)player.getUUID()));
            return false;
        }
        boolean invertCrouchMining = clientConfig.invertCrouchMining;
        return FallingTreesConfig.getCommonConfig().disableCrouchMining || player.isCrouching() == invertCrouchMining;
    }

    public static Optional<Float> getMiningSpeed(Player player, BlockPos blockPos, float baseSpeed) {
        TreeSpeed treeSpeed = TREE_SPEED_CACHES.compute(player.getUUID(), (uuid, speed) -> {
            if (speed == null || !speed.isValid(blockPos, baseSpeed)) {
                BlockState blockState = player.level().getBlockState(blockPos);
                TreeType tree = TreeRegistry.getTree(blockState);
                if (tree == null) {
                    return null;
                }
                TreeData data = TreeHandler.tryGatherTreeData(tree, blockPos, player.level(), player, true);
                if (data == null) {
                    return null;
                }
                return new TreeSpeed(baseSpeed, data.miningSpeedModifier().getMiningSpeed(baseSpeed), blockPos.immutable());
            }
            return speed;
        });
        return Optional.ofNullable(treeSpeed).map(TreeSpeed::getMiningSpeed);
    }

    public static final class TreeSpeed {
        private final float baseMiningSpeed;
        private final float miningSpeed;
        private final BlockPos blockPos;

        public TreeSpeed(float baseMiningSpeed, float miningSpeed, BlockPos blockPos) {
            this.baseMiningSpeed = baseMiningSpeed;
            this.miningSpeed = miningSpeed;
            this.blockPos = blockPos;
        }

        public float getMiningSpeed() {
            return this.miningSpeed;
        }

        public boolean isValid(BlockPos blockPos, float baseSpeed) {
            return Objects.equals(this.blockPos, blockPos) && this.baseMiningSpeed == baseSpeed;
        }
    }
}

