/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees;

import dev.architectury.platform.Platform;
import me.pandamods.fallingtrees.compat.Compat;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.event.EventHandler;
import me.pandamods.fallingtrees.registry.EntityRegistry;
import me.pandamods.fallingtrees.registry.SoundRegistry;
import me.pandamods.fallingtrees.registry.TreeRegistry;
import me.pandamods.fallingtrees.utils.BlockMapEntityData;
import me.pandamods.fallingtrees.utils.ItemListEntityData;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;

public class FallingTrees {
    public static final String MOD_ID = "fallingtrees";
    private static FallingTrees instance;
    public static final FallingTreesConfig CONFIG;
    private static Compat compat;

    public FallingTrees(Compat compat) {
        FallingTrees.compat = compat;
        TreeRegistry.TREES.register();
        SoundRegistry.SOUNDS.register();
        EntityRegistry.ENTITIES.register();
        EventHandler.register();
        if (!Platform.isNeoForge()) {
            EntityDataSerializers.registerSerializer(BlockMapEntityData.BLOCK_MAP);
            EntityDataSerializers.registerSerializer(ItemListEntityData.ITEM_LIST);
        }
        instance = this;
    }

    public static ResourceLocation resourceLocation(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static Compat getCompat() {
        if (compat == null) {
            throw new NullPointerException("Panda's Falling Tree's mod compat class not initialized.");
        }
        return compat;
    }

    public static FallingTrees getInstance() {
        return instance;
    }

    static {
        CONFIG = new FallingTreesConfig();
    }
}

