/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpackscreateintegration.backpack;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.common.MountedBackpackContainerMenu;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.common.MountedBackpackContext;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.init.ModContent;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SophisticatedMenuProvider;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageUpdatePayload;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class MountedSophisticatedBackpack
extends MountedStorageBase {
    public static final MapCodec<MountedSophisticatedBackpack> CODEC = ItemStack.OPTIONAL_CODEC.xmap(MountedSophisticatedBackpack::new, MountedStorageBase::getStorageStack).fieldOf("value");
    private IBackpackWrapper backpackWrapper = IBackpackWrapper.Noop.INSTANCE;
    @Nullable
    private WeakReference<Entity> contraptionEntity = null;
    private BlockPos localPos = BlockPos.ZERO;
    private Vec3 position = Vec3.ZERO;
    @Nullable
    private WeakReference<Level> level = null;
    protected boolean updateRenderAttributes = false;
    private boolean stackDirty = false;
    private boolean clearedNbt = false;

    public MountedSophisticatedBackpack(ItemStack storageStack) {
        super((MountedItemStorageType)ModContent.SOPHISTICATED_MOUNTED_BACKPACK_TYPE.get(), storageStack);
    }

    private void onStackChanged() {
        this.setStackDirty();
    }

    public void setStorageStack(ItemStack stack) {
        super.setStorageStack(stack);
        this.backpackWrapper = IBackpackWrapper.Noop.INSTANCE;
        this.updateRenderAttributes = true;
    }

    private void setStackDirty() {
        this.stackDirty = true;
    }

    private void setStackClean() {
        this.stackDirty = false;
    }

    public static MountedSophisticatedBackpack from(BackpackBlockEntity backpackBe) {
        return new MountedSophisticatedBackpack(backpackBe.getBackpackWrapper().getBackpack());
    }

    @Nullable
    private Entity getEntity() {
        return this.contraptionEntity == null ? null : (Entity)this.contraptionEntity.get();
    }

    public void setContraptionEntity(Entity entity) {
        this.contraptionEntity = new WeakReference<Entity>(entity);
    }

    private void refreshRenderBlockEntity() {
        AbstractContraptionEntity abstractContraptionEntity;
        BlockEntity blockEntity;
        Entity e = this.getEntity();
        if (e instanceof AbstractContraptionEntity && (blockEntity = (abstractContraptionEntity = (AbstractContraptionEntity)e).getContraption().getBlockEntityClientSide(this.localPos)) instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBe = (BackpackBlockEntity)blockEntity;
            backpackBe.setBackpack(this.getStorageStack());
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)abstractContraptionEntity.getContraption().getBlocks().get(this.localPos);
            if (blockInfo != null && blockInfo.state().getBlock() instanceof BackpackBlock) {
                backpackBe.setBlockState(blockInfo.state());
            }
            abstractContraptionEntity.getContraption().invalidateClientContraptionStructure();
        }
    }

    public void updateWithSyncedStorageStack(ItemStack storageStack, boolean refreshBlockRender) {
        this.setStorageStack(storageStack);
        this.updateRenderAttributes = true;
    }

    public IStorageWrapper getStorageWrapper() {
        if (this.backpackWrapper == IBackpackWrapper.Noop.INSTANCE) {
            this.backpackWrapper = BackpackWrapper.fromStack((ItemStack)this.getStorageStack());
            this.backpackWrapper.setContentsChangeHandler(this::onStackChanged);
        }
        return this.backpackWrapper;
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (this.getStorageStack().has(ModCoreDataComponents.STORAGE_UUID) && be instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBe = (BackpackBlockEntity)be;
            backpackBe.setBackpack(this.getStorageStack());
        }
    }

    private static MountedStorageContainerMenuBase createMenu(int id, Player pl, MountedBackpackContext context) {
        return new MountedBackpackContainerMenu(id, pl, context);
    }

    public static OptionalInt openMenu(ServerPlayer player, MountedBackpackContext context) {
        return player.openMenu((MenuProvider)new SophisticatedMenuProvider((w, p, pl) -> MountedSophisticatedBackpack.createMenu(w, pl, context), context.getDisplayName(player), false), context::toBuffer);
    }

    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        ServerLevel level = player.serverLevel();
        int contraptionEntityId = contraption.entity.getId();
        BlockPos localPos = info.pos();
        Vec3 localPosVec = Vec3.atCenterOf((Vec3i)localPos);
        OptionalInt id = MountedSophisticatedBackpack.openMenu(player, new MountedBackpackContext(contraptionEntityId, localPos));
        if (id.isPresent()) {
            Vec3 globalPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            this.onOpen(level, globalPos);
            return true;
        }
        return false;
    }

    protected Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    void initEntityLevelAndPositions(MovementContext context) {
        if (this.getEntity() == null) {
            AbstractContraptionEntity entity = context.contraption.entity;
            BlockPos localPos = context.localPos;
            Vec3 position = context.position;
            Level level = context.world;
            this.initEntityLevelAndPositions(entity, localPos, level, position);
        }
    }

    public void initEntityLevelAndPositions(AbstractContraptionEntity abstractContraptionEntity, BlockPos localPos, Level level, Vec3 position) {
        this.setContraptionEntity((Entity)abstractContraptionEntity);
        this.setLocalPos(localPos);
        this.setLevel(level);
        this.setPosition(position);
    }

    public void setLocalPos(BlockPos localPos) {
        this.localPos = localPos;
    }

    public void setLevel(Level level) {
        this.level = new WeakReference<Level>(level);
    }

    @Nullable
    protected Level getLevel() {
        return this.level == null ? null : (Level)this.level.get();
    }

    public void tick() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            this.sendStorageUpdatePayload();
        }
        if (level == null) {
            return;
        }
        if (level.isClientSide()) {
            this.clientTick(level);
            return;
        }
        this.runTickableUpgrades(level);
        this.runPickupOnItemEntities(level);
    }

    private void runTickableUpgrades(Level level) {
        this.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(this.getEntity(), level, new BlockPos((int)this.getPosition().x(), (int)this.getPosition().y(), (int)this.getPosition().z())));
    }

    private void runPickupOnItemEntities(Level level) {
        AABB aabb = this.getPickupBoundingBox();
        List collidedWithItemEntities = level.getEntitiesOfClass(ItemEntity.class, aabb);
        collidedWithItemEntities.forEach(itemEntity -> {
            if (itemEntity.isAlive()) {
                this.tryToPickup(level, (ItemEntity)itemEntity);
            }
        });
    }

    private void tryToPickup(Level level, ItemEntity itemEntity) {
        ItemStack remainingStack = itemEntity.getItem().copy();
        remainingStack = InventoryHelper.runPickupOnPickupResponseUpgrades((Level)level, (UpgradeHandler)this.getStorageWrapper().getUpgradeHandler(), (ItemStack)remainingStack, (boolean)false);
        if (remainingStack.getCount() < itemEntity.getItem().getCount()) {
            itemEntity.setItem(remainingStack);
        }
    }

    private AABB getPickupBoundingBox() {
        return new AABB(this.getPosition(), this.getPosition().add(1.0, 1.0, 1.0)).inflate(0.2);
    }

    private void clientTick(Level level) {
        if (this.updateRenderAttributes) {
            this.refreshRenderBlockEntity();
            this.updateRenderAttributes = false;
        }
        if (level.random.nextInt(10) == 0) {
            RenderInfo renderInfo = this.getStorageWrapper().getRenderInfo();
            this.renderUpgrades(level, level.random, renderInfo);
        }
    }

    private void renderUpgrades(Level level, RandomSource rand, RenderInfo renderInfo) {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        renderInfo.getUpgradeRenderData().forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer((UpgradeRenderDataType)type).ifPresent(renderer -> this.renderUpgrade((IUpgradeRenderer)renderer, level, rand, (UpgradeRenderDataType<?>)type, (IUpgradeRenderData)data)));
    }

    private <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, Level level, RandomSource rand, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(level, rand, vector -> vector.add((float)this.getPosition().x(), (float)this.getPosition().y() + 0.8f, (float)this.getPosition().z()), renderData));
    }

    private boolean isStackDirty() {
        return this.stackDirty;
    }

    public void sendStorageUpdatePayload() {
        if (!this.isStackDirty()) {
            return;
        }
        Entity entity = this.getEntity();
        if (entity == null || entity.level().isClientSide()) {
            return;
        }
        this.setStackClean();
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new MountedStorageUpdatePayload(entity.getId(), this.localPos, this.getStorageStack(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void setBlockRenderDirty() {
        AbstractContraptionEntity cEntity;
        StructureTemplate.StructureBlockInfo blockInfo;
        Entity entity = this.getEntity();
        if (entity instanceof AbstractContraptionEntity && (blockInfo = (StructureTemplate.StructureBlockInfo)(cEntity = (AbstractContraptionEntity)entity).getContraption().getBlocks().get(this.localPos)) != null && blockInfo.state().getBlock() instanceof BackpackBlock) {
            BlockState state = blockInfo.state();
            state = (BlockState)state.setValue((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(false));
            state = (BlockState)state.setValue((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(false));
            RenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
            for (TankPosition pos : renderInfo.getTankRenderInfos().keySet()) {
                if (pos == TankPosition.LEFT) {
                    state = (BlockState)state.setValue((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(true));
                    continue;
                }
                if (pos != TankPosition.RIGHT) continue;
                state = (BlockState)state.setValue((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(true));
            }
            state = (BlockState)state.setValue((Property)BackpackBlock.BATTERY, (Comparable)Boolean.valueOf(renderInfo.getBatteryRenderInfo().isPresent()));
            cEntity.setBlock(this.localPos, new StructureTemplate.StructureBlockInfo(blockInfo.pos(), state, blockInfo.nbt()));
        }
    }

    public void clearNbt() {
        Entity entity;
        if (!this.clearedNbt && (entity = this.getEntity()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)entity;
            abstractContraptionEntity.getContraption().getBlocks().computeIfPresent(this.localPos, (p, blockInfo) -> new StructureTemplate.StructureBlockInfo(blockInfo.pos(), blockInfo.state(), null));
            this.clearedNbt = true;
        }
    }

    protected IItemHandlerModifiable getExternalItemHandler() {
        return this.getStorageWrapper().getInventoryForInputOutput();
    }
}

