/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.client.event.HearthDebugRenderer;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageOne;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class ClientOnlyHelper {
    private static final Field SLIM = ObfuscationReflectionHelper.findField(PlayerModel.class, (String)"slim");

    public static void playEntitySound(SoundEvent sound, SoundSource source, float volume, float pitch, Entity entity) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new EntityBoundSoundInstance(sound, source, volume, pitch, entity, entity.level().random.nextLong()));
    }

    public static Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    public static void addHearthPosition(BlockPos pos) {
        HearthDebugRenderer.HEARTH_LOCATIONS.put(pos, new HashMap());
    }

    public static void removeHearthPosition(BlockPos pos) {
        HearthDebugRenderer.HEARTH_LOCATIONS.remove(pos);
    }

    public static void openConfigScreen() {
        Minecraft.getInstance().setScreen((Screen)new ConfigPageOne(Minecraft.getInstance().screen));
    }

    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static void sendPacketToServer(ServerboundSetCreativeModeSlotPacket packet) {
        Minecraft.getInstance().getConnection().send((Packet)packet);
    }

    public static GameType getGameMode() {
        return Minecraft.getInstance().gameMode.getPlayerMode();
    }

    public static boolean isPlayerModelSlim(RenderLayer<?, ?> layer) {
        EntityModel entityModel = layer.getParentModel();
        if (entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            try {
                return (Boolean)SLIM.get(playerModel);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isPlayerModelSlim(HumanoidModel<?> model) {
        if (model instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)model;
            try {
                return (Boolean)SLIM.get(playerModel);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void renderVerticalCropText(String text, int x, int y, int height, int color, GuiGraphics graphics) {
        Font font = Minecraft.getInstance().font;
        Minecraft mc = Minecraft.getInstance();
        if (height > 0) {
            int guiScale = (int)mc.getWindow().getGuiScale();
            int windowHeight = mc.getWindow().getHeight();
            int scissorX = x * guiScale;
            Objects.requireNonNull(font);
            int scissorY = windowHeight - (y + 9) * guiScale;
            int scissorWidth = font.width(text) * guiScale;
            int scissorHeight = height * guiScale;
            RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
            graphics.drawString(font, text, x, y, color, false);
            RenderSystem.disableScissor();
        }
    }

    static {
        SLIM.setAccessible(true);
    }
}

