/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EnchantmentRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemComponentsRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public record ItemRequirement(NegatableList<Either<TagKey<Item>, Item>> items, IntegerBounds count, IntegerBounds durability, NegatableList<EnchantmentRequirement> enchantments, Optional<Potion> potion, ItemComponentsRequirement components, Optional<Predicate<ItemStack>> predicate) {
    public static final Item WILDCARD_ITEM = null;
    private static final Codec<Either<TagKey<Item>, Item>> ITEM_CODEC = Codec.either(ConfigHelper.tagOrBuiltinCodec(Registries.ITEM, BuiltInRegistries.ITEM), (Codec)Codec.STRING).xmap(itemOrString -> {
        if (itemOrString.left().isPresent()) {
            return (Either)itemOrString.left().get();
        }
        String itemName = (String)itemOrString.right().get();
        if (itemName.equals("*")) {
            return Either.right((Object)WILDCARD_ITEM);
        }
        throw new IllegalArgumentException("Could not find item: " + itemName);
    }, tagOrItem -> (Either)tagOrItem.map(left -> Either.left((Object)Either.left((Object)left)), right -> right == WILDCARD_ITEM ? Either.right((Object)"*") : Either.left((Object)Either.right((Object)right))));
    public static final Codec<ItemRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ITEM_CODEC).fieldOf("items").forGetter(predicate -> predicate.items), (App)IntegerBounds.CODEC.optionalFieldOf("count", (Object)IntegerBounds.NONE).forGetter(predicate -> predicate.count), (App)IntegerBounds.CODEC.optionalFieldOf("durability", (Object)IntegerBounds.NONE).forGetter(predicate -> predicate.durability), (App)NegatableList.listCodec(EnchantmentRequirement.CODEC).optionalFieldOf("enchantments", new NegatableList()).forGetter(predicate -> predicate.enchantments), (App)BuiltInRegistries.POTION.byNameCodec().optionalFieldOf("potion").forGetter(predicate -> predicate.potion), (App)ItemComponentsRequirement.CODEC.optionalFieldOf("components", (Object)new ItemComponentsRequirement()).forGetter(predicate -> predicate.components)).apply((Applicative)instance, ItemRequirement::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemRequirement> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    public static final ItemRequirement NONE = new ItemRequirement(new NegatableList<Either<TagKey<Item>, Item>>(), IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), new ItemComponentsRequirement());

    public ItemRequirement(NegatableList<Either<TagKey<Item>, Item>> items, IntegerBounds count, IntegerBounds durability, NegatableList<EnchantmentRequirement> enchantments, Optional<Potion> potion, ItemComponentsRequirement components) {
        this(items, count, durability, enchantments, potion, components, Optional.empty());
    }

    public ItemRequirement(NegatableList<Either<TagKey<Item>, Item>> items, ItemComponentsRequirement components) {
        this(items, IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), components);
    }

    public ItemRequirement(Collection<Item> items, @Nullable Predicate<ItemStack> predicate) {
        this(new NegatableList<Either<TagKey<Item>, Item>>(items.stream().map(Either::right).toList()), IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), new ItemComponentsRequirement(), Optional.ofNullable(predicate));
    }

    public ItemRequirement(Predicate<ItemStack> predicate) {
        this(new NegatableList<Either<TagKey<Item>, Item>>(), IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), new ItemComponentsRequirement(), Optional.of(predicate));
    }

    public boolean test(ItemStack stack, boolean ignoreCount) {
        if (stack.isEmpty() && !this.items.isEmpty()) {
            return false;
        }
        if (!this.items.test(either -> (Boolean)either.map(arg_0 -> ((ItemStack)stack).is(arg_0), right -> right == WILDCARD_ITEM || stack.is(right)))) {
            return false;
        }
        if (this.predicate.isPresent()) {
            return this.predicate.get().test(stack);
        }
        if (!this.components.test(stack)) {
            return false;
        }
        if (!ignoreCount && !this.count.test(stack.getCount())) {
            return false;
        }
        if (!this.durability.test(stack.getMaxDamage() - stack.getDamageValue())) {
            return false;
        }
        if (this.potion.isPresent() && !this.potion.get().getEffects().equals(((Potion)((Holder)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.AWKWARD))).potion().get()).value()).getEffects())) {
            return false;
        }
        if (!this.enchantments.isEmpty()) {
            ItemEnchantments stackEnchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            stackEnchantments.entrySet().addAll(((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).entrySet());
            if (!this.enchantments.test(enchantment -> enchantment.test(stackEnchantments))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemRequirement that = (ItemRequirement)obj;
        return this.items.equals(that.items) && this.count.equals(that.count) && this.durability.equals(that.durability) && this.enchantments.equals(that.enchantments) && this.potion.equals(that.potion) && this.components.equals(that.components) && this.predicate.equals(that.predicate);
    }
}

