/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.data.codec.requirement.EffectsRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityFlagsRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.EquipmentRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.LocationRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.EntitySubRequirement;
import com.momosoftworks.coldsweat.data.codec.util.DoubleBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public record EntityRequirement(NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> entities, LocationRequirement location, LocationRequirement steppingOn, Optional<EffectsRequirement> effects, NbtRequirement nbt, Optional<EntityFlagsRequirement> flags, EquipmentRequirement equipment, Optional<EntitySubRequirement> typeSpecificData, NegatableList<String> team, Optional<EntityRequirement> vehicle, Optional<EntityRequirement> passenger, Optional<EntityRequirement> target, Map<Temperature.Trait, DoubleBounds> temperature, Optional<Predicate<Entity>> predicate) {
    public static final EntityRequirement NONE = new EntityRequirement(new NegatableList(), LocationRequirement.NONE, LocationRequirement.NONE, Optional.empty(), NbtRequirement.NONE, Optional.empty(), EquipmentRequirement.NONE, Optional.empty(), new NegatableList<String>(), Optional.empty(), Optional.empty(), Optional.empty(), new HashMap<Temperature.Trait, DoubleBounds>(), Optional.empty());
    public static final EntityType<?> WILDCARD_ENTITY = null;
    private static final Codec<Either<TagKey<EntityType<?>>, EntityType<?>>> ENTITY_CODEC = Codec.either(ConfigHelper.tagOrBuiltinCodec(Registries.ENTITY_TYPE, BuiltInRegistries.ENTITY_TYPE), (Codec)Codec.STRING).xmap(itemOrString -> {
        if (itemOrString.left().isPresent()) {
            return (Either)itemOrString.left().get();
        }
        String itemName = (String)itemOrString.right().get();
        if (itemName.equals("*")) {
            return Either.right(WILDCARD_ENTITY);
        }
        throw new IllegalArgumentException("Could not find item: " + itemName);
    }, tagOrItem -> (Either)tagOrItem.map(left -> Either.left((Object)Either.left((Object)left)), right -> right == WILDCARD_ENTITY ? Either.right((Object)"*") : Either.left((Object)Either.right((Object)right))));
    public static final Codec<EntityRequirement> SIMPLE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ENTITY_CODEC).fieldOf("entities").forGetter(requirement -> requirement.entities), (App)LocationRequirement.CODEC.optionalFieldOf("location", (Object)LocationRequirement.NONE).forGetter(requirement -> requirement.location), (App)LocationRequirement.CODEC.optionalFieldOf("stepping_on", (Object)LocationRequirement.NONE).forGetter(requirement -> requirement.steppingOn), (App)EffectsRequirement.CODEC.optionalFieldOf("effects").forGetter(requirement -> requirement.effects), (App)NbtRequirement.CODEC.optionalFieldOf("nbt", (Object)NbtRequirement.NONE).forGetter(requirement -> requirement.nbt), (App)EntityFlagsRequirement.CODEC.optionalFieldOf("flags").forGetter(requirement -> requirement.flags), (App)EquipmentRequirement.CODEC.optionalFieldOf("equipment", (Object)EquipmentRequirement.NONE).forGetter(requirement -> requirement.equipment), (App)EntitySubRequirement.CODEC.optionalFieldOf("type_specific").forGetter(requirement -> requirement.typeSpecificData), (App)NegatableList.codec(Codec.STRING).optionalFieldOf("team", new NegatableList()).forGetter(requirement -> requirement.team), (App)Codec.unboundedMap(Temperature.Trait.CODEC, DoubleBounds.CODEC).optionalFieldOf("temperature", new HashMap()).forGetter(requirement -> requirement.temperature)).apply((Applicative)instance, (type, location, standingOn, effects, nbt, flags, equipment, typeData, team, temperature) -> new EntityRequirement((NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>>)type, (LocationRequirement)location, (LocationRequirement)standingOn, (Optional<EffectsRequirement>)effects, (NbtRequirement)nbt, (Optional<EntityFlagsRequirement>)flags, (EquipmentRequirement)equipment, (Optional<EntitySubRequirement>)typeData, (NegatableList<String>)team, Optional.empty(), Optional.empty(), Optional.empty(), (Map<Temperature.Trait, DoubleBounds>)temperature)));
    private static final List<Codec<EntityRequirement>> REQUIREMENT_CODEC_STACK = new ArrayList<Codec<EntityRequirement>>(List.of(SIMPLE_CODEC));

    public EntityRequirement(NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> entities, LocationRequirement location, LocationRequirement steppingOn, Optional<EffectsRequirement> effects, NbtRequirement nbt, Optional<EntityFlagsRequirement> flags, EquipmentRequirement equipment, Optional<EntitySubRequirement> typeSpecificData, NegatableList<String> team, Optional<EntityRequirement> vehicle, Optional<EntityRequirement> passenger, Optional<EntityRequirement> target, Map<Temperature.Trait, DoubleBounds> temperature) {
        this(entities, location, steppingOn, effects, nbt, flags, equipment, typeSpecificData, team, vehicle, passenger, target, temperature, Optional.empty());
    }

    public EntityRequirement(NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> entities) {
        this(entities, LocationRequirement.NONE, LocationRequirement.NONE, Optional.empty(), NbtRequirement.NONE, Optional.empty(), EquipmentRequirement.NONE, Optional.empty(), new NegatableList<String>(), Optional.empty(), Optional.empty(), Optional.empty(), new HashMap<Temperature.Trait, DoubleBounds>());
    }

    public EntityRequirement(Collection<EntityType<?>> entities, @Nullable Predicate<Entity> predicate) {
        this(new NegatableList(entities.stream().map(Either::right).toList()), LocationRequirement.NONE, LocationRequirement.NONE, Optional.empty(), NbtRequirement.NONE, Optional.empty(), EquipmentRequirement.NONE, Optional.empty(), new NegatableList<String>(), Optional.empty(), Optional.empty(), Optional.empty(), new HashMap<Temperature.Trait, DoubleBounds>(), Optional.ofNullable(predicate));
    }

    public EntityRequirement(Predicate<Entity> predicate) {
        this(new NegatableList(), LocationRequirement.NONE, LocationRequirement.NONE, Optional.empty(), NbtRequirement.NONE, Optional.empty(), EquipmentRequirement.NONE, Optional.empty(), new NegatableList<String>(), Optional.empty(), Optional.empty(), Optional.empty(), new HashMap<Temperature.Trait, DoubleBounds>(), Optional.ofNullable(predicate));
    }

    public static Codec<EntityRequirement> getCodec() {
        return REQUIREMENT_CODEC_STACK.getLast();
    }

    private static void addCodecStack() {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ENTITY_CODEC).fieldOf("entities").forGetter(requirement -> requirement.entities), (App)LocationRequirement.CODEC.optionalFieldOf("location", (Object)LocationRequirement.NONE).forGetter(requirement -> requirement.location), (App)LocationRequirement.CODEC.optionalFieldOf("stepping_on", (Object)LocationRequirement.NONE).forGetter(requirement -> requirement.steppingOn), (App)EffectsRequirement.CODEC.optionalFieldOf("effects").forGetter(requirement -> requirement.effects), (App)NbtRequirement.CODEC.optionalFieldOf("nbt", (Object)NbtRequirement.NONE).forGetter(requirement -> requirement.nbt), (App)EntityFlagsRequirement.CODEC.optionalFieldOf("flags").forGetter(requirement -> requirement.flags), (App)EquipmentRequirement.CODEC.optionalFieldOf("equipment", (Object)EquipmentRequirement.NONE).forGetter(requirement -> requirement.equipment), (App)EntitySubRequirement.CODEC.optionalFieldOf("type_specific").forGetter(requirement -> requirement.typeSpecificData), (App)NegatableList.codec(Codec.STRING).optionalFieldOf("team", new NegatableList()).forGetter(requirement -> requirement.team), (App)EntityRequirement.getCodec().optionalFieldOf("vehicle").forGetter(requirement -> requirement.vehicle), (App)EntityRequirement.getCodec().optionalFieldOf("passenger").forGetter(requirement -> requirement.passenger), (App)EntityRequirement.getCodec().optionalFieldOf("target").forGetter(requirement -> requirement.target), (App)Codec.unboundedMap(Temperature.Trait.CODEC, DoubleBounds.CODEC).optionalFieldOf("temperature", new HashMap()).forGetter(requirement -> requirement.temperature)).apply((Applicative)instance, EntityRequirement::new));
        REQUIREMENT_CODEC_STACK.add((Codec<EntityRequirement>)codec);
    }

    public boolean test(Entity entity) {
        block21: {
            block22: {
                EntityType type;
                if (entity == null) {
                    return false;
                }
                if (this.predicate.isPresent()) {
                    return this.predicate.get().test(entity);
                }
                if (Objects.equals(this, NONE)) {
                    return true;
                }
                if (!this.entities.isEmpty() && !this.entities.test(arg_0 -> EntityRequirement.lambda$test$31(type = entity.getType(), arg_0))) {
                    return false;
                }
                if (!this.location.test(entity.level(), entity.position())) {
                    return false;
                }
                if (!this.steppingOn.test(entity.level(), entity.position().add(0.0, -0.5, 0.0))) {
                    return false;
                }
                if (this.effects.isPresent() && !this.effects.get().test(entity)) {
                    return false;
                }
                if (this.flags.isPresent() && !this.flags.get().test(entity)) {
                    return false;
                }
                if (!this.equipment.test(entity)) {
                    return false;
                }
                if (this.typeSpecificData.isPresent() && !this.typeSpecificData.get().test(entity, entity.level(), entity.position())) {
                    return false;
                }
                if (this.vehicle.isPresent() && !this.vehicle.get().test(entity.getVehicle())) {
                    return false;
                }
                if (this.passenger.isPresent() && !this.passenger.get().test(entity.getPassengers().isEmpty() ? null : (Entity)entity.getPassengers().get(0))) {
                    return false;
                }
                if (!this.target.isPresent()) break block21;
                if (!(entity instanceof Monster)) break block22;
                Monster monster = (Monster)entity;
                if (this.target.get().test((Entity)monster.getTarget())) break block21;
            }
            return false;
        }
        if (!this.team.isEmpty()) {
            PlayerTeam team = entity.getTeam();
            if (team == null || !this.team.test(arg_0 -> EntityRequirement.lambda$test$32((Team)team, arg_0))) {
                return false;
            }
            return false;
        }
        if (!this.nbt.test(entity)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!EntityTempManager.isTemperatureEnabled((Entity)living) && !this.temperature.isEmpty()) {
                return false;
            }
            for (Map.Entry<Temperature.Trait, DoubleBounds> entry : this.temperature.entrySet()) {
                double value = Temperature.get(living, entry.getKey());
                if (entry.getValue().test(value)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return EntityRequirement.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntityRequirement that = (EntityRequirement)obj;
        return this.entities.equals(that.entities) && this.location.equals(that.location) && this.steppingOn.equals(that.steppingOn) && this.effects.equals(that.effects) && this.nbt.equals(that.nbt) && this.flags.equals(that.flags) && this.equipment.equals(that.equipment) && this.typeSpecificData.equals(that.typeSpecificData) && this.vehicle.equals(that.vehicle) && this.passenger.equals(that.passenger) && this.target.equals(that.target) && this.predicate.equals(that.predicate) && this.temperature.equals(that.temperature);
    }

    private static /* synthetic */ boolean lambda$test$32(Team team, String t) {
        return t.equals(team.getName());
    }

    private static /* synthetic */ boolean lambda$test$31(EntityType type, Either either) {
        return (Boolean)either.map(arg_0 -> ((EntityType)type).is(arg_0), t -> t == WILDCARD_ENTITY || t == type);
    }

    static {
        for (int i = 0; i < 4; ++i) {
            EntityRequirement.addCodecStack();
        }
    }
}

