/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class SoulLampFuelledTrigger
extends SimpleCriterionTrigger<Instance> {
    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, ItemStack fuelStack, ItemStack lampStack) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(fuelStack, lampStack));
    }

    public record Instance(Optional<ContextAwarePredicate> player, ItemPredicate[] fuelStack, ItemPredicate lampStack) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)ItemPredicate.CODEC.listOf().xmap(list -> list.toArray(new ItemPredicate[0]), arr -> List.of(arr)).fieldOf("fuel_item").forGetter(Instance::fuelStack), (App)ItemPredicate.CODEC.fieldOf("lamp_item").forGetter(Instance::lampStack)).apply((Applicative)instance, Instance::new));

        public boolean matches(ItemStack fuelStack, ItemStack lampStack) {
            if (!this.lampStack.test(lampStack)) {
                return false;
            }
            if (fuelStack.isEmpty()) {
                return true;
            }
            for (ItemPredicate predicate : this.fuelStack) {
                if (!predicate.test(fuelStack)) continue;
                return true;
            }
            return false;
        }
    }
}

