/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.core.advancement.trigger.TriggerHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class BlockAffectTempTrigger
extends SimpleCriterionTrigger<Instance> {
    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, BlockPos pos, double distance, double totalEffect) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(player, pos, distance, totalEffect));
    }

    public record Instance(Optional<ContextAwarePredicate> player, BlockPredicate block, MinMaxBounds.Doubles distance, MinMaxBounds.Doubles totalEffect, List<TriggerHelper.TempCondition> conditions) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)BlockPredicate.CODEC.fieldOf("block").forGetter(Instance::block), (App)MinMaxBounds.Doubles.CODEC.fieldOf("distance").forGetter(Instance::distance), (App)MinMaxBounds.Doubles.CODEC.fieldOf("total_effect").forGetter(Instance::totalEffect), (App)Codec.list(TriggerHelper.TempCondition.CODEC).fieldOf("conditions").forGetter(Instance::conditions)).apply((Applicative)instance, Instance::new));

        public boolean matches(ServerPlayer player, BlockPos pos, double distance, double totalEffect) {
            Map<Temperature.Trait, Double> temps = Temperature.getTemperatures((LivingEntity)player);
            return this.distance.matches(distance) && this.totalEffect.matches(totalEffect) && this.block.matches(player.serverLevel(), pos) && this.conditions.stream().allMatch(condition -> condition.matches(temps.getOrDefault((Object)condition.trait(), 0.0)));
        }
    }
}

