/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.kubejs.event.builder;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.compat.kubejs.util.KubeHelper;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InsulatorBuilderJS {
    public List<Insulation> insulation = new ArrayList<Insulation>();
    public Insulation.Slot slot = null;
    public NegatableList<ItemRequirement> itemPredicate = new NegatableList();
    public NegatableList<EntityRequirement> entityPredicate = new NegatableList();
    public AttributeModifierMap attributes = new AttributeModifierMap();
    public Map<ResourceLocation, Double> immuneTempModifiers = new HashMap<ResourceLocation, Double>();
    public boolean fillSlots = false;
    public boolean hideIfUnmet = false;
    public String hintKey = null;
    public String hintText = null;

    public InsulatorBuilderJS items(String ... items) {
        List<Item> itemList = RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, ConfigHelper.getItems(items));
        if (itemList.isEmpty() && items.length != 0) {
            this.itemPredicate.add(ItemRequirement.NONE, true);
        } else {
            this.itemPredicate.add(new ItemRequirement(itemList, null), false);
        }
        return this;
    }

    public InsulatorBuilderJS insulation(double cold, double heat) {
        this.insulation.add(new StaticInsulation(cold, heat));
        return this;
    }

    public InsulatorBuilderJS adaptiveInsulation(double insulation, double speed) {
        this.insulation.add(new AdaptiveInsulation(insulation, speed));
        return this;
    }

    public InsulatorBuilderJS slot(String slot) {
        this.slot = Insulation.Slot.byName(slot);
        return this;
    }

    public InsulatorBuilderJS itemPredicate(Predicate<ItemStack> itemPredicate) {
        this.itemPredicate.add(new ItemRequirement(itemPredicate), false);
        return this;
    }

    public InsulatorBuilderJS entityPredicate(Predicate<Entity> entityPredicate) {
        this.entityPredicate.add(new EntityRequirement(entityPredicate), false);
        return this;
    }

    public InsulatorBuilderJS attribute(String attributeId, double amount, String operation) {
        Holder attribute = BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)attributeId)).orElse(null);
        if (!KubeHelper.expect(attributeId, attribute, Holder.class)) {
            return this;
        }
        this.attributes.put((Holder<Attribute>)attribute, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"kubejs"), amount, AttributeModifier.Operation.valueOf((String)operation.toUpperCase(Locale.ROOT))));
        return this;
    }

    public InsulatorBuilderJS immuneToModifier(String modifierId, double immunity) {
        ResourceLocation location = ResourceLocation.parse((String)modifierId);
        if (!TempModifierRegistry.getEntries().containsKey((Object)location)) {
            ColdSweat.LOGGER.warn("Tried to add immunity to non-existent temperature modifier: {}", (Object)location);
            return this;
        }
        this.immuneTempModifiers.put(ResourceLocation.parse((String)modifierId), immunity);
        return this;
    }

    public InsulatorBuilderJS fillSlots(boolean multiSlot) {
        this.fillSlots = multiSlot;
        return this;
    }

    public InsulatorBuilderJS hideIfUnmet(boolean hide) {
        this.hideIfUnmet = hide;
        return this;
    }

    public InsulatorBuilderJS hintKey(String key) {
        this.hintKey = key;
        return this;
    }

    public InsulatorBuilderJS hintText(String text) {
        this.hintText = text;
        return this;
    }

    public InsulatorData build() {
        Optional<InsulatorData.HintText> hint = this.hintKey != null || this.hintText != null ? Optional.of(new InsulatorData.HintText(Optional.ofNullable(this.hintKey), Optional.ofNullable(this.hintText))) : Optional.empty();
        InsulatorData data = new InsulatorData(this.itemPredicate, this.slot, this.insulation, this.entityPredicate, this.attributes, this.immuneTempModifiers, this.fillSlots, this.hideIfUnmet, hint);
        data.setConfigType(ConfigData.Type.KUBEJS);
        return data;
    }
}

