/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.kubejs.event;

import com.momosoftworks.coldsweat.api.event.core.init.DefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.kubejs.KubeBindings;
import dev.latvian.mods.kubejs.entity.KubeLivingEntityEvent;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class DefaultModifiersEventJS
implements KubeLivingEntityEvent {
    private final DefaultTempModifiersEvent event;

    public DefaultModifiersEventJS(DefaultTempModifiersEvent event) {
        this.event = event;
    }

    public LivingEntity getEntity() {
        return this.event.getEntity();
    }

    public Map<Temperature.Trait, List<TempModifier>> getModifiers() {
        return this.event.getModifiers();
    }

    public void addModifier(String trait, TempModifier modifier) {
        Temperature.Trait t = KubeBindings.getTrait(trait);
        this.event.getModifiers(t).add(modifier);
    }

    public void addModifiers(String trait, TempModifier ... modifiers) {
        Temperature.Trait t = KubeBindings.getTrait(trait);
        this.event.getModifiers(t).addAll(List.of(modifiers));
    }

    public void addModifier(String trait, TempModifier modifier, String duplicatePolicy, Placement params) {
        Temperature.Trait t = KubeBindings.getTrait(trait);
        Temperature.addModifier(this.event.getModifiers(t), modifier, Placement.Duplicates.byName(duplicatePolicy), 1, params);
    }

    public void addModifierById(String trait, ResourceLocation id, Consumer<TempModifier> modifierBuilder, String duplicatePolicy, Placement params) {
        TempModifierRegistry.getValue(id).ifPresent(mod -> {
            modifierBuilder.accept((TempModifier)mod);
            this.addModifier(trait, (TempModifier)mod, duplicatePolicy, params);
        });
    }

    public void removeModifiers(String trait, TempModifier modifier, String matchPolicy) {
        Temperature.Trait t = KubeBindings.getTrait(trait);
        Placement.Duplicates policy = Placement.Duplicates.byName(matchPolicy);
        this.event.getModifiers(t).removeIf(mod -> policy.check((TempModifier)mod, modifier));
    }

    public Placement placed(String mode, String order, Predicate<TempModifier> predicate) {
        return Placement.of(Placement.Mode.byName(mode), Placement.Order.byName(order), predicate);
    }
}

