/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.create;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.blockentity.ThermolithBlockEntity;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ColdSweatDisplaySources {
    public static final DeferredRegister<DisplaySource> DISPLAY_SOURCES = DeferredRegister.create((ResourceKey)CreateRegistries.DISPLAY_SOURCE, (String)"cold_sweat");
    public static final DeferredHolder<DisplaySource, DisplaySource> THERMOLITH = DISPLAY_SOURCES.register("cold_sweat_thermolith", () -> {
        Thermolith source = new Thermolith();
        DisplaySource.BY_BLOCK.add((Object)((Block)ModBlocks.THERMOLITH.value()), (Object)source);
        return source;
    });

    public static class Thermolith
    extends SingleLineDisplaySource {
        protected MutableComponent provideLine(DisplayLinkContext displayLinkContext, DisplayTargetStats displayTargetStats) {
            BlockEntity blockEntity = displayLinkContext.getSourceBlockEntity();
            if (blockEntity instanceof ThermolithBlockEntity) {
                ThermolithBlockEntity thermolith = (ThermolithBlockEntity)blockEntity;
                double temperature = WorldHelper.getTemperatureAt(thermolith.getLevel(), thermolith.getBlockPos());
                Temperature.Units units = Temperature.Units.values()[displayLinkContext.sourceConfig().getInt("Units")];
                double convertedTemp = Temperature.convert(temperature, Temperature.Units.MC, units, true);
                String places = units == Temperature.Units.MC ? "%.2f" : "%.0f";
                String text = String.format(places + "%s", convertedTemp, units.getFormattedName());
                return Component.literal((String)text);
            }
            return Component.empty();
        }

        protected boolean allowsLabeling(DisplayLinkContext displayLinkContext) {
            return true;
        }

        public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
            super.initConfigurationWidgets(context, builder, isFirstLine);
            if (!isFirstLine) {
                builder.addSelectionScrollInput(0, 137, (input, label) -> input.forOptions(List.of(Component.literal((String)Temperature.Units.F.getFormattedName()), Component.literal((String)Temperature.Units.C.getFormattedName()), Component.literal((String)Temperature.Units.MC.getFormattedName()))).titled(Component.translatable((String)"cold_sweat.config.units.name")), "Units");
            }
        }

        public Component getName() {
            return Component.translatable((String)"block.cold_sweat.thermolith");
        }
    }
}

