/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.event.common.insulation.InsulationTickEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ItemBreakEvent;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class ProcessEquipmentInsulation {
    @SubscribeEvent
    public static void applyArmorInsulation(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.tickCount % 20 == 0 && !player.level().isClientSide) {
                AdvancementHolder advancement;
                AtomicInteger fullyInsulatedSlots = new AtomicInteger(0);
                FastMap<String, Double> armorInsulation = new FastMap<String, Double>();
                double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
                double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
                double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
                for (ItemStack armorStack : player.getArmorSlots()) {
                    if (!(armorStack.getItem() instanceof Equipable)) continue;
                    ProcessEquipmentInsulation.applyBuiltinArmorInsulation(armorInsulation, armorStack, player, worldTemp, minTemp, maxTemp);
                    ProcessEquipmentInsulation.applySewnArmorInsulation(armorInsulation, armorStack, player, worldTemp, minTemp, maxTemp, fullyInsulatedSlots);
                    double armorAmount = armorStack.getAttributeModifiers().modifiers().stream().filter(entry -> entry.attribute() == Attributes.ARMOR && entry.slot() == EquipmentSlotGroup.ARMOR).map(entry -> entry.modifier().amount()).mapToDouble(Double::doubleValue).sum();
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_protection", Math.min(armorAmount, 20.0));
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_protection", Math.min(armorAmount, 20.0));
                }
                for (ItemStack curio : CompatManager.Curios.getCurios((LivingEntity)player)) {
                    for (InsulatorData insulator : ConfigSettings.INSULATING_CURIOS.get().get((Object)curio.getItem())) {
                        if (!insulator.test((Entity)player, curio)) continue;
                        ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_curios", insulator.getCold());
                        ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_curios", insulator.getHeat());
                    }
                }
                InsulationTickEvent insulationEvent = new InsulationTickEvent(player, armorInsulation);
                NeoForge.EVENT_BUS.post((Event)insulationEvent);
                if (!insulationEvent.isCanceled()) {
                    double cold = insulationEvent.getProperty("cold");
                    double heat = insulationEvent.getProperty("heat");
                    if (cold > 0.0 || heat > 0.0) {
                        Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new ArmorInsulationTempModifier(cold, heat).tickRate(20)).expires(20), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                    }
                }
                if (fullyInsulatedSlots.get() >= 4 && serverPlayer.getServer() != null && (advancement = serverPlayer.getServer().getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"full_insulation"))) != null) {
                    serverPlayer.getAdvancements().award(advancement, "requirement");
                }
            }
        }
    }

    private static void applyBuiltinArmorInsulation(Map<String, Double> armorInsulation, ItemStack armorStack, Player player, double worldTemp, double minTemp, double maxTemp) {
        ArrayList armorInsulators = new ArrayList(ConfigSettings.INSULATING_ARMORS.get().get((Object)armorStack.getItem()));
        if (!armorInsulators.isEmpty()) {
            Double newFactor = null;
            for (InsulatorData armorInsulator : armorInsulators) {
                if (!armorInsulator.test((Entity)player, armorStack)) continue;
                List<Insulation> insulations = Insulation.deepCopy(armorInsulator.insulation());
                for (Insulation insul : insulations) {
                    if (insul instanceof AdaptiveInsulation) {
                        AdaptiveInsulation adaptive = (AdaptiveInsulation)insul;
                        if (newFactor == null) {
                            AdaptiveInsulation.readFactorFromArmor(adaptive, armorStack);
                            newFactor = AdaptiveInsulation.calculateChange(adaptive, worldTemp, minTemp, maxTemp);
                            AdaptiveInsulation.setFactorToArmor(armorStack, newFactor);
                        }
                        adaptive.setFactor(newFactor);
                    }
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_armor", insul.getCold());
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_armor", insul.getHeat());
                }
            }
        }
    }

    private static void applySewnArmorInsulation(Map<String, Double> armorInsulation, ItemStack armorStack, Player player, double worldTemp, double minTemp, double maxTemp, AtomicInteger fullyInsulatedSlots) {
        Optional<ItemInsulationCap> icap = ItemInsulationManager.getInsulationCap(armorStack);
        if (icap.isEmpty()) {
            return;
        }
        ItemInsulationCap cap = icap.get();
        List<InsulatorData> insulators = RequirementHolder.filterValid(ItemInsulationManager.getAppliedArmorInsulators(armorStack), (Entity)player);
        for (InsulatorData insulator : insulators) {
            for (Insulation insulation : insulator.insulation()) {
                ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_insulators", insulation.getCold());
                ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_insulators", insulation.getHeat());
            }
        }
        if ((armorInsulation.getOrDefault("cold_insulators", 0.0) + armorInsulation.getOrDefault("heat_insulators", 0.0)) / 2.0 >= (double)ItemInsulationManager.getInsulationSlots(armorStack)) {
            fullyInsulatedSlots.incrementAndGet();
        }
        cap = cap.calcAdaptiveInsulation(worldTemp, minTemp, maxTemp);
        cap = ProcessEquipmentInsulation.popExtraInsulation(cap, armorStack, player);
    }

    private static void mapAdd(Map<String, Double> map, String key, double value) {
        map.put(key, map.getOrDefault(key, 0.0) + value);
    }

    private static ItemInsulationCap popExtraInsulation(ItemInsulationCap cap, ItemStack armorStack, Player player) {
        List<Pair<ItemStack, List<InsulatorData>>> totalInsulation = cap.getInsulation();
        int filledInsulationSlots = totalInsulation.size();
        if (filledInsulationSlots > ItemInsulationManager.getInsulationSlots(armorStack)) {
            WorldHelper.playEntitySound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, (Entity)player, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        while (filledInsulationSlots > ItemInsulationManager.getInsulationSlots(armorStack)) {
            ItemStack removedItem = (ItemStack)totalInsulation.getLast().getFirst();
            cap = cap.removeInsulationItem((ItemStack)totalInsulation.get(totalInsulation.size() - 1).getFirst());
            WorldHelper.entityDropItem((Entity)player, removedItem);
            --filledInsulationSlots;
        }
        return cap;
    }

    @SubscribeEvent
    public static void onArmorBroken(ItemBreakEvent event) {
        ItemStack stack = event.getItemStack();
        LivingEntity entity = event.getEntity();
        if (ItemInsulationManager.isInsulatable(stack)) {
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> {
                for (Pair<ItemStack, List<InsulatorData>> insulation : cap.getInsulation()) {
                    ItemEntity itemEntity = WorldHelper.entityDropItem((Entity)entity, (ItemStack)insulation.getFirst());
                    itemEntity.setPickUpDelay(8);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingIncomingDamageEvent event) {
        DamageSource source = event.getSource();
        if (source.is(DamageTypes.HOT_FLOOR) && event.getEntity().getItemBySlot(EquipmentSlot.FEET).is(ModItems.HOGLIN_BOOTS)) {
            event.setCanceled(true);
        }
    }
}

