/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.event.core.init.DefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.core.init.GatherDefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ContainerChangedEvent;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.AcclimationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.CaveBiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ElevationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntitiesTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntityClimateTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FreezingTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FrigidnessTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.InventoryItemsTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.MountTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ShadeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulSproutTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ThermalSourceTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WarmthTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.SidedCapabilityCache;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.ModUpdater;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.ModAttributes;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.core.init.ModDataAttachments;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.init.ModParticleTypes;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.tag.ModEntityTags;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class EntityTempManager {
    public static final Temperature.Trait[] VALID_TEMPERATURE_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForTemperature).toArray(Temperature.Trait[]::new);
    public static final Temperature.Trait[] VALID_MODIFIER_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForModifiers).toArray(Temperature.Trait[]::new);
    public static final Temperature.Trait[] VALID_ATTRIBUTE_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForAttributes).toArray(Temperature.Trait[]::new);
    public static final Set<EntityType<? extends LivingEntity>> TEMPERATURE_ENABLED_ENTITIES = new HashSet<EntityType<? extends LivingEntity>>((Collection<EntityType<? extends LivingEntity>>)ImmutableSet.builder().add((Object)EntityType.PLAYER).build());
    public static SidedCapabilityCache<ITemperatureCap, Entity> CAP_CACHE = new SidedCapabilityCache(ModDataAttachments.ENTITY_TEMPERATURE, Entity::isRemoved);
    public static Map<Entity, Map<ResourceLocation, Double>> TEMP_MODIFIER_IMMUNITIES = new WeakHashMap<Entity, Map<ResourceLocation, Double>>();
    private static final Field MENU_OWNER = ObfuscationReflectionHelper.findField(InventoryMenu.class, (String)"owner");

    public static Optional<ITemperatureCap> getTemperatureCap(Entity entity) {
        return EntityTempManager.isTemperatureEnabled(entity) ? Optional.ofNullable(CAP_CACHE.get(entity)) : Optional.empty();
    }

    public static Map<Temperature.Trait, List<TempModifier>> gatherTempModifiers(LivingEntity entity) {
        DefaultTempModifiersEvent modifiersEvent = new DefaultTempModifiersEvent(entity);
        NeoForge.EVENT_BUS.post((Event)modifiersEvent);
        Map<Temperature.Trait, List<TempModifier>> modifiers = modifiersEvent.getModifiers();
        for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
            GatherDefaultTempModifiersEvent gatherEvent = new GatherDefaultTempModifiersEvent(entity, modifiers.get((Object)trait), trait);
            NeoForge.EVENT_BUS.post((Event)gatherEvent);
            modifiers.put(trait, gatherEvent.getModifiers());
        }
        return modifiers;
    }

    private static void updateInventoryTempAttributes(ItemStack oldStack, ItemStack newStack, LivingEntity entity) {
        for (ItemTempData itemTempData : ConfigSettings.ITEM_TEMPERATURES.get().get((Object)oldStack.getItem())) {
            entity.getAttributes().removeAttributeModifiers(itemTempData.attributeModifiers().getMap());
        }
        for (ItemTempData itemTempData : ConfigSettings.ITEM_TEMPERATURES.get().get((Object)newStack.getItem())) {
            if (!itemTempData.test((Entity)entity, newStack)) continue;
            entity.getAttributes().addTransientAttributeModifiers(itemTempData.attributeModifiers().getMap());
        }
    }

    private static Player getOwner(InventoryMenu menu) {
        try {
            return (Player)MENU_OWNER.get(menu);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static void updateInsulationAttributeModifiers(LivingEntity entity, ItemStack from, ItemStack to, Insulation.Slot slot) {
        for (InsulatorData insulatorData : ItemInsulationManager.getInsulatorsForStack(from, slot)) {
            entity.getAttributes().removeAttributeModifiers(insulatorData.attributes().getMap());
        }
        for (InsulatorData insulatorData : RequirementHolder.filterValid(ItemInsulationManager.getInsulatorsForStack(to, slot), (Entity)entity)) {
            entity.getAttributes().addTransientAttributeModifiers(insulatorData.attributes().getMap());
        }
    }

    public static Set<EntityType<? extends LivingEntity>> getEntitiesWithTemperature() {
        return ImmutableSet.copyOf(TEMPERATURE_ENABLED_ENTITIES);
    }

    public static boolean isTemperatureEnabled(EntityType<?> type) {
        return TEMPERATURE_ENABLED_ENTITIES.contains(type);
    }

    public static boolean isTemperatureEnabled(Entity entity) {
        return TEMPERATURE_ENABLED_ENTITIES.contains(entity.getType());
    }

    public static boolean hasClimateData(EntityType<?> entity) {
        return ConfigSettings.ENTITY_CLIMATES.get().containsKey(entity);
    }

    public static boolean hasClimateData(Entity entity) {
        return ConfigSettings.ENTITY_CLIMATES.get().containsKey((Object)entity.getType());
    }

    public static boolean isPeacefulMode(LivingEntity entity) {
        return entity.level().getDifficulty() == Difficulty.PEACEFUL && ConfigSettings.USE_PEACEFUL_MODE.get() != false;
    }

    public static boolean isImmuneToTemperature(LivingEntity player) {
        return player == null || !player.isAlive() || EntityTempManager.isPeacefulMode(player) || player.hasEffect(ModEffects.GRACE);
    }

    public static double getColdResistance(LivingEntity entity) {
        return entity.hasEffect(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get(entity, Temperature.Trait.COLD_RESISTANCE);
    }

    public static double getHeatResistance(LivingEntity player) {
        return player.hasEffect(MobEffects.FIRE_RESISTANCE) && ConfigSettings.FIRE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get(player, Temperature.Trait.HEAT_RESISTANCE);
    }

    public static double getResistance(double temperature, LivingEntity player) {
        return temperature < 0.0 ? EntityTempManager.getColdResistance(player) : EntityTempManager.getHeatResistance(player);
    }

    public static Map<ItemStack, InsulatorData> getInsulatorsOnEntity(LivingEntity entity) {
        HashMap<ItemStack, InsulatorData> insulators = new HashMap<ItemStack, InsulatorData>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (!slot.isArmor() || (stack = entity.getItemBySlot(slot)).isEmpty()) continue;
            ConfigSettings.INSULATING_ARMORS.get().get((Object)stack.getItem()).forEach(insul -> insulators.put(stack, (InsulatorData)insul));
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> cap.getInsulation().stream().map(Pair::getFirst).forEach(item -> ConfigSettings.INSULATION_ITEMS.get().get((Object)item.getItem()).forEach(insul -> insulators.put((ItemStack)item, (InsulatorData)insul))));
        }
        for (ItemStack curio : CompatManager.Curios.getCurios(entity)) {
            ConfigSettings.INSULATING_CURIOS.get().get((Object)curio.getItem()).forEach(insul -> insulators.put(curio, (InsulatorData)insul));
        }
        return insulators;
    }

    public static Map<ItemStack, Pair<ItemTempData, Either<Integer, ItemTempData.SlotType>>> getInventoryTemperaturesOnEntity(Player player) {
        HashMap<ItemStack, Pair<ItemTempData, Either<Integer, ItemTempData.SlotType>>> tempItems = new HashMap<ItemStack, Pair<ItemTempData, Either<Integer, ItemTempData.SlotType>>>();
        for (int i = 0; i < player.getInventory().items.size(); ++i) {
            ItemStack stack = (ItemStack)player.getInventory().items.get(i);
            if (stack.isEmpty()) continue;
            int slotIndex = i;
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)stack.getItem()).forEach(temp -> tempItems.put(stack, Pair.of((Object)temp, (Object)Either.left((Object)slotIndex))));
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (!slot.isArmor() || (stack = player.getItemBySlot(slot)).isEmpty()) continue;
            ItemTempData.SlotType slotType = ItemTempData.SlotType.fromEquipment(slot);
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)stack.getItem()).forEach(temp -> tempItems.put(stack, Pair.of((Object)temp, (Object)Either.right((Object)((Object)slotType)))));
        }
        for (ItemStack curio : CompatManager.Curios.getCurios((LivingEntity)player)) {
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)curio.getItem()).forEach(temp -> tempItems.put(curio, Pair.of((Object)temp, (Object)Either.right((Object)((Object)ItemTempData.SlotType.CURIO)))));
        }
        ItemStack offhand = player.getOffhandItem();
        if (!offhand.isEmpty()) {
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)offhand.getItem()).forEach(temp -> tempItems.put(offhand, Pair.of((Object)temp, (Object)Either.right((Object)((Object)ItemTempData.SlotType.HAND)))));
        }
        return tempItems;
    }

    @Nullable
    public static AttributeInstance getAttribute(Temperature.Trait trait, LivingEntity entity) {
        return switch (trait) {
            case Temperature.Trait.WORLD -> entity.getAttribute(ModAttributes.WORLD_TEMPERATURE);
            case Temperature.Trait.BASE -> entity.getAttribute(ModAttributes.BASE_BODY_TEMPERATURE);
            case Temperature.Trait.RATE -> entity.getAttribute(ModAttributes.TEMP_RATE);
            case Temperature.Trait.FREEZING_POINT -> entity.getAttribute(ModAttributes.FREEZING_POINT);
            case Temperature.Trait.BURNING_POINT -> entity.getAttribute(ModAttributes.BURNING_POINT);
            case Temperature.Trait.HEAT_RESISTANCE -> entity.getAttribute(ModAttributes.HEAT_RESISTANCE);
            case Temperature.Trait.COLD_RESISTANCE -> entity.getAttribute(ModAttributes.COLD_RESISTANCE);
            case Temperature.Trait.HEAT_DAMPENING -> entity.getAttribute(ModAttributes.HEAT_DAMPENING);
            case Temperature.Trait.COLD_DAMPENING -> entity.getAttribute(ModAttributes.COLD_DAMPENING);
            default -> throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + String.valueOf((Object)trait) + "\" is not a valid trait!"));
        };
    }

    public static Collection<AttributeModifier> getAllAttributeModifiers(LivingEntity entity, AttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(operation == null ? attribute.getModifiers() : attribute.getModifiers().stream().filter(modifier -> modifier.operation() == operation).toList());
        modifiers.addAll(EntityTempManager.getAllEquipmentAttributeModifiers(entity, attribute, operation));
        return modifiers;
    }

    public static Collection<AttributeModifier> getAllEquipmentAttributeModifiers(LivingEntity entity, AttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (!slot.isArmor() || (stack = entity.getItemBySlot(slot)).isEmpty()) continue;
            modifiers.addAll(ItemInsulationManager.getAttributeModifiersForSlot(stack, (Holder<Attribute>)attribute.getAttribute(), slot, operation, (Entity)entity));
        }
        return modifiers;
    }

    public static AttributeModifier makeAttributeModifier(Temperature.Trait trait, double value, AttributeModifier.Operation operation) {
        if (!trait.isForAttributes()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + String.valueOf((Object)trait) + "\" is not a valid trait!"));
        }
        return new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)(trait.getSerializedName() + "_modifier")), value, operation);
    }

    public static boolean isTemperatureAttribute(Holder<Attribute> attribute) {
        return attribute.getKey().location().getNamespace().equals("cold_sweat");
    }

    public static List<AttributeInstance> getAllTemperatureAttributes(LivingEntity entity) {
        return Arrays.stream(VALID_ATTRIBUTE_TRAITS).map(trait -> EntityTempManager.getAttribute(trait, entity)).filter(Objects::nonNull).toList();
    }

    static {
        MENU_OWNER.setAccessible(true);
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void handleModUpdates(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (EntityTempManager.isTemperatureEnabled(entity) && entity instanceof LivingEntity) {
                ModUpdater.updateEntity((LivingEntity)entity);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void defineDefaultModifiers(DefaultTempModifiersEvent event) {
            LivingEntity entity = event.getEntity();
            boolean isPlayer = entity instanceof Player;
            boolean isTempSensitive = entity.getType().is(ModEntityTags.TEMPERATURE_SENSITIVE);
            if (EntityTempManager.hasClimateData((Entity)entity)) {
                boolean wasAdvanced;
                boolean isAdvanced = ConfigSettings.ADVANCED_ENTITY_TEMPERATURE.get();
                if (isAdvanced != (wasAdvanced = entity.getPersistentData().getBoolean("AdvancedTemperature"))) {
                    Temperature.getModifiers(entity).clear();
                    entity.getPersistentData().putBoolean("AdvancedTemperature", isAdvanced);
                }
                if (!isAdvanced) {
                    event.addModifier(List.of(Temperature.Trait.WORLD, Temperature.Trait.FREEZING_POINT, Temperature.Trait.BURNING_POINT), (TempModifier)new EntityClimateTempModifier().tickRate(200), Placement.Duplicates.BY_CLASS, Placement.BEFORE_FIRST);
                    return;
                }
            }
            double tickMultiplier = isPlayer ? 1.0 : (isTempSensitive ? 4.0 : 40.0);
            int slowTickRate = (int)Math.min(60.0 * tickMultiplier, 400.0);
            int mediumTickRate = (int)(10.0 * tickMultiplier * 2.0);
            int mediumTickRate2 = (int)(10.0 * tickMultiplier);
            int fastTickRate = (int)(5.0 * tickMultiplier);
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new BiomeTempModifier(isPlayer ? 49 : (isTempSensitive ? 16 : 9)).tickRate(mediumTickRate), Placement.Duplicates.BY_CLASS, Placement.BEFORE_FIRST);
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new ElevationTempModifier(isPlayer ? 49 : (isTempSensitive ? 16 : 1)).tickRate(mediumTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof BiomeTempModifier));
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new ShadeTempModifier().tickRate(10), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod -> mod instanceof ElevationTempModifier));
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new CaveBiomeTempModifier(isPlayer ? 6 : (isTempSensitive ? 5 : 3)).tickRate(mediumTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof ElevationTempModifier));
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new BlockTempModifier(isPlayer ? -1 : 4).tickRate(fastTickRate), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new EntitiesTempModifier().tickRate(mediumTickRate2), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifierById(Temperature.Trait.WORLD, ResourceLocation.parse((String)"sereneseasons:season"), mod -> mod.tickRate(slowTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BiomeTempModifier));
            event.addModifierById(Temperature.Trait.WORLD, ResourceLocation.parse((String)"weather2:storm"), mod -> mod.tickRate(slowTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BiomeTempModifier));
            event.addModifierById(Temperature.Trait.WORLD, ResourceLocation.parse((String)"valkyrienskies:ship_blocks"), mod -> mod.tickRate(mediumTickRate2), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BlockTempModifier));
            if (isPlayer && !(entity instanceof DummyPlayer)) {
                event.addModifier(List.of(Temperature.Trait.FREEZING_POINT, Temperature.Trait.BURNING_POINT), (TempModifier)new AcclimationTempModifier().tickRate(20), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
                event.addModifier(Arrays.asList(VALID_MODIFIER_TRAITS), (TempModifier)new InventoryItemsTempModifier().tickRate(5), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            }
        }

        @SubscribeEvent
        public static void initModifiersOnEntity(EntityJoinLevelEvent event) {
            LivingEntity living;
            Entity entity = event.getEntity();
            if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).level().isClientSide() && EntityTempManager.isTemperatureEnabled((Entity)living)) {
                EntityTempManager.getTemperatureCap((Entity)living).ifPresent(cap -> {
                    Map<Temperature.Trait, List<TempModifier>> modifiers = EntityTempManager.gatherTempModifiers(living);
                    cap.clearModifiers();
                    cap.setModifiers(modifiers);
                    TaskScheduler.scheduleServer(() -> {
                        cap.tick(living);
                        Temperature.updateTemperature(living, cap, true);
                        Temperature.updateModifiers(living, cap);
                    }, 1);
                });
            }
        }

        @SubscribeEvent
        public static synchronized void finalizeEntities(EntityLeaveLevelEvent event) {
            if (EntityTempManager.isTemperatureEnabled(event.getEntity())) {
                TEMP_MODIFIER_IMMUNITIES.entrySet().removeIf(e -> ((Entity)e.getKey()).isRemoved());
            }
        }

        @SubscribeEvent
        public static void tickTemperature(EntityTickEvent.Pre event) {
            LivingEntity entity;
            Entity entity2 = event.getEntity();
            if (!(entity2 instanceof LivingEntity) || !TEMPERATURE_ENABLED_ENTITIES.contains((entity = (LivingEntity)entity2).getType())) {
                return;
            }
            EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
                if (!entity.level().isClientSide) {
                    if (entity instanceof Player || entity.tickCount % 5 == 0) {
                        cap.tick(entity);
                    }
                } else {
                    cap.tickDummy(entity);
                }
                AtomicBoolean sync = new AtomicBoolean(false);
                for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                    List<TempModifier> modifiers = cap.getModifiers(trait);
                    for (int i = 0; i < modifiers.size(); ++i) {
                        boolean expired;
                        TempModifier modifier = modifiers.get(i);
                        if (modifier.getTicksExisted() % modifier.getTickRate() == 0) {
                            modifier.tick(entity);
                        }
                        if (modifier.isDirty()) {
                            sync.set(true);
                            modifier.markClean();
                        }
                        int expireTime = modifier.getExpireTime();
                        boolean bl = expired = modifier.setTicksExisted(modifier.getTicksExisted() + 1) > expireTime && expireTime != -1;
                        if (!expired) continue;
                        cap.removeModifier(modifier, trait);
                        modifier.onRemoved(entity, trait);
                        Temperature.updateSiblingsRemove(modifiers, entity, trait, modifier);
                        --i;
                    }
                }
                if (sync.get()) {
                    Temperature.updateModifiers(entity, cap);
                }
                if (!entity.level().isClientSide() && EntityTempManager.hasClimateData((Entity)entity) && entity.tickCount % 5 == 0 && entity.getRandom().nextDouble() < 0.1) {
                    double worldTemp = cap.getTrait(Temperature.Trait.WORLD);
                    double entityX = entity.getX();
                    double entityY = entity.getY() + (double)entity.getBbHeight();
                    double entityZ = entity.getZ();
                    if (worldTemp < cap.getTrait(Temperature.Trait.FREEZING_POINT)) {
                        WorldHelper.spawnParticleBatch(entity.level(), (ParticleOptions)ModParticleTypes.MOB_COLD.get(), entityX, entityY, entityZ, 0.5, 0.5, 0.5, entity.getRandom().nextInt(2, 4), 0.0);
                    } else if (worldTemp > cap.getTrait(Temperature.Trait.BURNING_POINT)) {
                        WorldHelper.spawnParticleBatch(entity.level(), (ParticleOptions)ModParticleTypes.MOB_HOT.get(), entityX, entityY, entityZ, 0.5, 0.5, 0.5, entity.getRandom().nextInt(2, 4), 0.0);
                    }
                }
                entity.setData(ModDataAttachments.ENTITY_TEMPERATURE, cap);
            });
        }

        @SubscribeEvent
        public static void carryOverPersistentAttributes(PlayerEvent.Clone event) {
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            if (!newPlayer.level().isClientSide) {
                ((Collection)EntityTempManager.getTemperatureCap((Entity)oldPlayer).map(ITemperatureCap::getPersistentAttributes).orElse(new HashSet())).forEach(attr -> {
                    AttributeInstance newAttr = newPlayer.getAttribute(Holder.direct((Object)attr));
                    AttributeInstance oldAttr = oldPlayer.getAttribute(Holder.direct((Object)attr));
                    if (newAttr != null && oldAttr != null) {
                        newAttr.setBaseValue(oldAttr.getBaseValue());
                        EntityTempManager.getTemperatureCap((Entity)newPlayer).ifPresent(cap -> cap.markPersistentAttribute((Attribute)attr));
                    }
                });
            }
        }

        @SubscribeEvent
        public static void handlePlayerReset(PlayerEvent.Clone event) {
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            EntityTempManager.getTemperatureCap((Entity)newPlayer).ifPresent(cap -> {
                if (!event.isWasDeath()) {
                    EntityTempManager.getTemperatureCap((Entity)oldPlayer).ifPresent(cap::copy);
                }
            });
        }

        @SubscribeEvent
        public static void addInventoryListeners(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                final Player player = (Player)entity;
                player.containerMenu.addSlotListener(new ContainerListener(){

                    public void slotChanged(AbstractContainerMenu menu, int slotIndex, ItemStack stack) {
                        Slot slot = menu.getSlot(slotIndex);
                        if (!(slot instanceof ResultSlot) && slot.container == player.getInventory() && ConfigSettings.INSULATION_ITEMS.get().containsKey((Object)stack.getItem())) {
                            player.awardRecipesByKey(List.of(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"sewing_table")));
                        }
                    }

                    public void dataChanged(AbstractContainerMenu menu, int slot, int value) {
                    }
                });
            }
        }

        @SubscribeEvent
        public static void cancelDisabledModifiers(TempModifierEvent.Calculate.Pre event) {
            TempModifier modifier = event.getModifier();
            ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
            if (modifierKey != null && ConfigSettings.DISABLED_MODIFIERS.get().contains(modifierKey)) {
                modifier.expires(0);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void calculateModifierImmunity(EntityTickEvent.Pre event) {
            LivingEntity entity;
            Entity entity2 = event.getEntity();
            if (entity2 instanceof LivingEntity && !(entity = (LivingEntity)entity2).level().isClientSide() && entity.tickCount % 20 == 0 && EntityTempManager.isTemperatureEnabled((Entity)entity)) {
                FastMap<ResourceLocation, Double> immunities = new FastMap<ResourceLocation, Double>();
                for (Map.Entry<ItemStack, InsulatorData> entry : EntityTempManager.getInsulatorsOnEntity(entity).entrySet()) {
                    ItemStack stack;
                    InsulatorData insulator = entry.getValue();
                    if (!insulator.test((Entity)entity, stack = entry.getKey())) continue;
                    immunities.putAll(insulator.immuneTempModifiers());
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    for (Map.Entry<ItemStack, Pair<ItemTempData, Either<Integer, ItemTempData.SlotType>>> entry : EntityTempManager.getInventoryTemperaturesOnEntity(player).entrySet()) {
                        ItemTempData itemTemp = (ItemTempData)entry.getValue().getFirst();
                        ItemStack stack = entry.getKey();
                        if (!((Boolean)((Either)entry.getValue().getSecond()).map(slot -> itemTemp.test((Entity)player, stack, (int)slot, null), slot -> itemTemp.test((Entity)entity, stack, (ItemTempData.SlotType)((Object)slot)))).booleanValue()) continue;
                        immunities.putAll(itemTemp.immuneTempModifiers());
                    }
                    if (player.getVehicle() != null) {
                        for (MountData mountData : ConfigSettings.INSULATED_MOUNTS.get().get((Object)player.getVehicle().getType())) {
                            immunities.putAll(mountData.modifierImmunities());
                        }
                    }
                }
                TEMP_MODIFIER_IMMUNITIES.put((Entity)entity, immunities);
            }
        }

        @SubscribeEvent
        public static void checkModifierImmunity(TempModifierEvent.Calculate.Post event) {
            if (event.getEntity() instanceof DummyPlayer) {
                return;
            }
            if (!event.getTrait().isForAttributes()) {
                return;
            }
            TempModifier modifier = event.getModifier();
            ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
            LivingEntity entity = event.getEntity();
            double immunity = TEMP_MODIFIER_IMMUNITIES.getOrDefault(entity, Collections.emptyMap()).getOrDefault(modifierKey, 0.0);
            if (immunity > 0.0) {
                Function<Double, Double> oldFunction = event.getFunction();
                event.setFunction(temp -> {
                    double lastInput = modifier instanceof BiomeTempModifier ? Temperature.getNeutralWorldTemp(entity) : temp;
                    return CSMath.blend((Double)oldFunction.apply((Double)temp), lastInput, immunity, 0.0, 1.0);
                });
            }
        }

        @SubscribeEvent
        public static void preventFullyImmuneModifiers(TempModifierEvent.Add event) {
            if (event.getEntity() instanceof DummyPlayer) {
                return;
            }
            if (!event.getTrait().isForAttributes()) {
                return;
            }
            TempModifier modifier = event.getModifier();
            ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
            LivingEntity entity = event.getEntity();
            double immunity = TEMP_MODIFIER_IMMUNITIES.getOrDefault(entity, Collections.emptyMap()).getOrDefault(modifierKey, 0.0);
            if (immunity == 1.0) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void handleWaterFreezingFire(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!player.level().isClientSide) {
                if (player.tickCount % 5 == 0) {
                    if (!player.isSpectator() && (WorldHelper.isInWater((Entity)player) || player.tickCount % 40 == 0 && WorldHelper.isRainingAt(player.level(), player.blockPosition()))) {
                        Temperature.addModifier((LivingEntity)player, new WaterTempModifier().tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                    }
                    if (player.isFreezing()) {
                        Temperature.addOrReplaceModifier((LivingEntity)player, new FreezingTempModifier(), Temperature.Trait.BASE, Placement.Duplicates.BY_CLASS);
                    }
                    if (player.isOnFire() && Temperature.hasModifier((LivingEntity)player, Temperature.Trait.WORLD, WaterTempModifier.class)) {
                        player.extinguishFire();
                        Temperature.removeModifiers((LivingEntity)player, Temperature.Trait.WORLD, WaterTempModifier.class);
                    }
                }
                if (player.isFreezing() && player.getTicksFrozen() > 0) {
                    boolean hasIcePotion;
                    AtomicReference<Double> insulation = new AtomicReference<Double>(0.0);
                    boolean bl = hasIcePotion = player.hasEffect(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get() != false;
                    if (!hasIcePotion) {
                        Temperature.getModifier((LivingEntity)player, Temperature.Trait.RATE, ArmorInsulationTempModifier.class).ifPresent(insulModifier -> insulation.updateAndGet(v -> v + insulModifier.getNBT().getDouble("Hot") + insulModifier.getNBT().getDouble("Cold")));
                    }
                    if (!hasIcePotion && !(insulation.get() > 0.0) && (double)player.tickCount % Math.max(1.0, 37.0 - insulation.get()) == 0.0) {
                        player.setTicksFrozen(player.getTicksFrozen() - 1);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onTridentUse(LivingEntityUseItemEvent.Stop event) {
            LivingEntity entity = event.getEntity();
            ItemStack stack = event.getItem();
            if (!entity.level().isClientSide()) {
                TaskScheduler.scheduleServer(() -> {
                    if (stack.getItem() instanceof TridentItem && EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)stack, (LivingEntity)entity) > 0.0f && !entity.isInWaterOrBubble()) {
                        Temperature.removeModifiers(entity, Temperature.Trait.WORLD, WaterTempModifier.class);
                    }
                }, 5);
            }
        }

        @SubscribeEvent
        public static void tickInventoryAttributeChanges(PlayerTickEvent.Pre event) {
            if (event.getEntity().tickCount % 20 == 0) {
                for (ItemStack item : event.getEntity().getInventory().items) {
                    EntityTempManager.updateInventoryTempAttributes(item, item, (LivingEntity)event.getEntity());
                }
            }
        }

        @SubscribeEvent
        public static void updateInventoryAttributesOnSlotChange(ContainerChangedEvent event) {
            AbstractContainerMenu abstractContainerMenu = event.getContainer();
            if (abstractContainerMenu instanceof InventoryMenu) {
                InventoryMenu inventory = (InventoryMenu)abstractContainerMenu;
                EntityTempManager.updateInventoryTempAttributes(event.getOldStack(), event.getNewStack(), (LivingEntity)EntityTempManager.getOwner(inventory));
            }
        }

        @SubscribeEvent
        public static void tickInsulationAttributeChanges(EntityTickEvent.Pre event) {
            Entity entity = event.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (entity.tickCount % 20 == 0) {
                    for (ItemStack armor : living.getArmorSlots()) {
                        if (armor.isEmpty()) continue;
                        EntityTempManager.updateInsulationAttributeModifiers(living, armor, armor, Insulation.Slot.ARMOR);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void updateInsulationAttributesOnEquipmentChange(LivingEquipmentChangeEvent event) {
            EntityTempManager.updateInsulationAttributeModifiers(event.getEntity(), event.getFrom(), event.getTo(), Insulation.Slot.ARMOR);
            for (ItemStack armor : event.getEntity().getArmorSlots()) {
                if (armor.isEmpty()) continue;
                EntityTempManager.updateInsulationAttributeModifiers(event.getEntity(), armor, armor, Insulation.Slot.ARMOR);
            }
        }

        @SubscribeEvent
        public static void cancelFreezingDamage(LivingIncomingDamageEvent event) {
            if (event.getSource().equals(event.getEntity().level().damageSources().freeze()) && event.getEntity().hasEffect(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get().booleanValue()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onInsulationAdded(MobEffectEvent.Added event) {
            LivingEntity entity = event.getEntity();
            MobEffectInstance effect = event.getEffectInstance();
            if (!entity.level().isClientSide && EntityTempManager.isTemperatureEnabled((Entity)entity) && (effect.getEffect() == ModEffects.FRIGIDNESS || effect.getEffect() == ModEffects.WARMTH)) {
                boolean isWarmth = effect.getEffect() == ModEffects.WARMTH;
                int strength = effect.getAmplifier() + 1;
                ThermalSourceTempModifier newMod = (ThermalSourceTempModifier)(isWarmth ? new WarmthTempModifier(strength) : new FrigidnessTempModifier(strength)).expires(effect.getDuration());
                ThermalSourceTempModifier oldMod = Temperature.getModifier(entity, Temperature.Trait.WORLD, ThermalSourceTempModifier.class).orElse(null);
                if (oldMod == null || oldMod.getStrength() <= strength) {
                    Temperature.removeModifiers(entity, Temperature.Trait.WORLD, newMod.getClass());
                    Temperature.addModifier(entity, newMod, Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                }
            }
        }

        @SubscribeEvent
        public static void onInsulationRemoved(MobEffectEvent.Remove event) {
            Optional<ThermalSourceTempModifier> modifier;
            LivingEntity entity = event.getEntity();
            MobEffectInstance effect = event.getEffectInstance();
            if (effect != null && !entity.level().isClientSide && EntityTempManager.isTemperatureEnabled((Entity)entity) && (effect.getEffect() == ModEffects.FRIGIDNESS || effect.getEffect() == ModEffects.WARMTH) && (modifier = Temperature.getModifier(entity, Temperature.Trait.WORLD, ThermalSourceTempModifier.class)).isPresent()) {
                boolean isWarmth = effect.getEffect() == ModEffects.WARMTH;
                CompoundTag nbt = modifier.get().getNBT();
                if (isWarmth) {
                    nbt.putInt("Warming", 0);
                } else {
                    nbt.putInt("Cooling", 0);
                }
                if (isWarmth ? !entity.hasEffect(ModEffects.FRIGIDNESS) : !entity.hasEffect(ModEffects.WARMTH)) {
                    Temperature.removeModifiers(entity, Temperature.Trait.WORLD, mod -> mod instanceof ThermalSourceTempModifier);
                }
            }
        }

        @SubscribeEvent
        public static void onSleep(SleepFinishedTimeEvent event) {
            if (!event.getLevel().isClientSide()) {
                event.getLevel().players().forEach(player -> {
                    if (player.isSleeping()) {
                        double temp = Temperature.get((LivingEntity)player, Temperature.Trait.CORE);
                        Temperature.set((LivingEntity)player, Temperature.Trait.CORE, temp / 4.0);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void playerRiding(PlayerTickEvent.Pre event) {
            Player player;
            if (!event.getEntity().level().isClientSide() && event.getEntity().tickCount % 5 == 0 && (player = event.getEntity()).getVehicle() != null) {
                Minecart minecart;
                Entity mount = player.getVehicle();
                if (mount instanceof Minecart && (minecart = (Minecart)mount).getDisplayBlockState().getBlock() == ModBlocks.MINECART_INSULATION.value()) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new MountTempModifier(1.0, 1.0).tickRate(5)).expires(5), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                } else {
                    MountData entityInsul = ConfigSettings.INSULATED_MOUNTS.get().get((Object)mount.getType()).stream().filter(mnt -> mnt.test(mount)).findFirst().orElse(null);
                    if (entityInsul != null) {
                        Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new MountTempModifier(entityInsul.coldInsulation(), entityInsul.heatInsulation()).tickRate(5)).expires(5), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onEatFood(LivingEntityUseItemEvent.Finish event) {
            ItemStack item = event.getItem();
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (!(item.getUseAnimation() != UseAnim.DRINK && item.getUseAnimation() != UseAnim.EAT || event.getEntity().level().isClientSide)) {
                    for (FoodData foodData : ConfigSettings.FOOD_TEMPERATURES.get().get((Object)item.getItem())) {
                        if (foodData == null || !foodData.test(item)) continue;
                        double temperature = foodData.temperature();
                        int duration = foodData.duration();
                        Temperature.Trait trait = foodData.duration() > 0 ? Temperature.Trait.BASE : Temperature.Trait.CORE;
                        FoodTempModifier foodModifier = item.getItem() == ModItems.SOUL_SPROUT.value() ? new SoulSproutTempModifier(temperature) : new FoodTempModifier(temperature);
                        foodModifier.getNBT().putString("item", BuiltInRegistries.ITEM.getKey((Object)item.getItem()).toString());
                        foodModifier.getNBT().putInt("duration", duration);
                        Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)foodModifier.expires(duration)).tickRate(duration), trait, Placement.Duplicates.EXACT);
                    }
                }
            }
        }
    }
}

