/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class CapabilityCache<C, K extends IAttachmentHolder> {
    protected final Map<K, C> cache = new WeakHashMap<K, C>();
    protected final Predicate<K> invalidator;
    protected final Supplier<AttachmentType<C>> capability;

    public CapabilityCache(Supplier<AttachmentType<C>> capability, Predicate<K> invalidator) {
        this.capability = capability;
        this.invalidator = invalidator;
    }

    public CapabilityCache(Supplier<AttachmentType<C>> capability) {
        this.capability = capability;
        this.invalidator = null;
    }

    public C get(K key) {
        return (C)this.cache.computeIfAbsent((IAttachmentHolder)key, (Function<IAttachmentHolder, C>)((Function<IAttachmentHolder, Object>)e -> {
            this.cleanExpiredEntries();
            return e.getData(this.capability);
        }));
    }

    public int size() {
        return this.cache.size();
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    protected void cleanExpiredEntries() {
        if (this.invalidator != null) {
            this.removeIf(this.invalidator);
        }
    }

    public void ifPresent(K key, Consumer<C> consumer) {
        C cap = this.cache.get(key);
        if (cap != null) {
            consumer.accept(cap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIf(Predicate<K> predicate) {
        Map<K, C> map = this.cache;
        synchronized (map) {
            ArrayList<IAttachmentHolder> removedKeys = new ArrayList<IAttachmentHolder>(this.cache.size());
            for (Map.Entry<K, C> entry : this.cache.entrySet()) {
                IAttachmentHolder key = (IAttachmentHolder)entry.getKey();
                if (!predicate.test(key)) continue;
                removedKeys.add(key);
            }
            for (int i = 0; i < removedKeys.size(); ++i) {
                this.cache.remove(removedKeys.get(i));
            }
        }
    }
}

