/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;

public class ShadeTempModifier
extends TempModifier {
    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        Level level = entity.level();
        if (level.dimensionType().hasCeiling() || !level.dimensionType().hasSkyLight()) {
            return temp -> temp;
        }
        double darkness = 1.0 - (double)level.getBrightness(LightLayer.SKY, entity.blockPosition()) / 15.0;
        double overcast = level.getRainLevel(1.0f);
        double shade = Math.max(darkness *= Math.max(0.0, WorldHelper.getTimeMultiplier((LevelAccessor)level)), overcast);
        double shadeAmount = CSMath.blend(0.0, ConfigSettings.SHADE_TEMP_OFFSET.get(), shade, 0.0, 1.0);
        return temp -> temp + shadeAmount;
    }
}

