/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.event.core.registry;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.configuration.RegistryModifierData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.Event;

public abstract class LoadRegistriesEvent
extends Event {
    RegistryAccess registryAccess;
    RegistryMultiMap<RegistryHolder<?>, Holder<? extends ConfigData>> registries;

    public LoadRegistriesEvent(RegistryAccess registryAccess, RegistryMultiMap<RegistryHolder<?>, Holder<? extends ConfigData>> registries) {
        this.registryAccess = registryAccess;
        this.registries = registries;
    }

    public RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }

    public RegistryMultiMap<RegistryHolder<?>, Holder<? extends ConfigData>> getRegistries() {
        return this.registries;
    }

    public <T extends ConfigData> Collection<Holder<T>> getRegistry(RegistryHolder<T> registry) {
        return this.registries.get((Object)registry);
    }

    public <T extends ConfigData> void addRegistryEntry(RegistryHolder<T> registry, Holder<T> value) {
        this.registries.put(registry, value);
    }

    public <T extends ConfigData> void addRegistryEntry(RegistryHolder<T> registry, T value) {
        this.registries.put(registry, (Holder<? extends ConfigData>)Holder.direct(value));
    }

    public <T extends ConfigData> void addRegistryEntries(RegistryHolder<T> registry, Collection<Holder<T>> values) {
        this.registries.putAll(registry, values);
    }

    public static class Post
    extends LoadRegistriesEvent {
        public Post(RegistryAccess registryAccess, RegistryMultiMap<RegistryHolder<?>, Holder<? extends ConfigData>> registries) {
            super(registryAccess, registries);
        }
    }

    public static class Pre
    extends LoadRegistriesEvent {
        private Multimap<ResourceKey<Registry<? extends ConfigData>>, RegistryModifierData<?>> modifiers;

        public Pre(RegistryAccess registryAccess, RegistryMultiMap<RegistryHolder<?>, Holder<? extends ConfigData>> registries, Multimap<RegistryHolder<?>, Holder<RegistryModifierData<?>>> modifiers) {
            super(registryAccess, registries);
        }

        public Multimap<ResourceKey<Registry<? extends ConfigData>>, RegistryModifierData<?>> getRegistryModifiers() {
            return ImmutableMultimap.copyOf(this.modifiers);
        }
    }
}

