/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.entities.goals;

import com.kyanite.deeperdarker.content.entities.goals.DisturbanceListener;
import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class DisturbanceGoal
extends Goal {
    private final PathfinderMob mob;
    private final double speedModifier;

    public DisturbanceGoal(PathfinderMob mob, double speedModifier) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof DisturbanceListener) {
            DisturbanceListener listener = (DisturbanceListener)pathfinderMob;
            return listener.getDisturbanceLocation() != null;
        }
        return false;
    }

    public boolean canContinueToUse() {
        assert (this.mob instanceof DisturbanceListener);
        if (this.mob.getNavigation().isDone()) {
            ((DisturbanceListener)this.mob).setDisturbanceLocation(null);
            return false;
        }
        return this.mob.getNavigation().getTargetPos() == ((DisturbanceListener)this.mob).getDisturbanceLocation();
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.mob.getNavigation().createPath(((DisturbanceListener)this.mob).getDisturbanceLocation(), 0), this.speedModifier);
    }

    public void stop() {
        this.mob.getNavigation().stop();
    }
}

