/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AddChargeRecipe
extends CustomRecipe {
    private final Ingredient targetItem;
    private final Ingredient targetCharge;
    private final Item result;
    private final int chargesPerItem;
    private final boolean canOverflow;

    public AddChargeRecipe(CraftingBookCategory category, Ingredient arrow, Ingredient rope, Item result, int chargesPerItem, boolean canOverflow) {
        super(category);
        this.targetItem = arrow;
        this.targetCharge = rope;
        this.result = result;
        this.chargesPerItem = chargesPerItem;
        this.canOverflow = canOverflow;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        ItemStack arrow = null;
        ItemStack rope = null;
        int newTotalCharges = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (this.targetItem.test(stack)) {
                if (arrow != null) {
                    return false;
                }
                arrow = stack;
                newTotalCharges += ((Integer)stack.getOrDefault(ModComponents.CHARGES.get(), (Object)0)).intValue();
                continue;
            }
            if (this.targetCharge.test(stack)) {
                rope = stack;
                newTotalCharges += this.chargesPerItem;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return arrow != null && rope != null && (this.canOverflow || newTotalCharges <= (Integer)this.result.getDefaultInstance().getOrDefault(ModComponents.MAX_CHARGES.get(), (Object)0));
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        int newTotalCharges = 0;
        ItemStack arrow = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (this.targetItem.test(stack)) {
                arrow = stack;
                newTotalCharges += ((Integer)stack.getOrDefault(ModComponents.CHARGES.get(), (Object)0)).intValue();
                continue;
            }
            if (!this.targetCharge.test(stack)) continue;
            newTotalCharges += this.chargesPerItem;
        }
        ItemStack returnArrow = arrow.transmuteCopy((ItemLike)this.result, 1);
        returnArrow.set(ModComponents.CHARGES.get(), (Object)Math.min(newTotalCharges, (Integer)returnArrow.getOrDefault(ModComponents.MAX_CHARGES.get(), (Object)0)));
        return returnArrow;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.ROPE_ARROW_ADD.get();
    }

    public static class Serializer
    implements RecipeSerializer<AddChargeRecipe> {
        private static final MapCodec<AddChargeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.targetItem), (App)Ingredient.CODEC.fieldOf("charge").forGetter(recipe -> recipe.targetCharge), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("charges_per_item", (Object)1).forGetter(recipe -> recipe.chargesPerItem), (App)Codec.BOOL.optionalFieldOf("can_overfill", (Object)false).forGetter(recipe -> recipe.canOverflow)).apply((Applicative)instance, AddChargeRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, AddChargeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CraftingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.targetItem, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.targetCharge, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), recipe -> recipe.result, (StreamCodec)ByteBufCodecs.VAR_INT, recipe -> recipe.chargesPerItem, (StreamCodec)ByteBufCodecs.BOOL, recipe -> recipe.canOverflow, AddChargeRecipe::new);

        public MapCodec<AddChargeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AddChargeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

