/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.cannon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.common.block.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class CannonUtils {
    public static Pair<@Nullable CannonTrajectory, Float> computeTrajectory(CannonAccess access, Vec3 targetPos, ShootingMode shootingMode) {
        CannonBlockTile cannonTile = access.getInternalCannon();
        Vec3 cannonPos = access.getCannonGlobalPosition(0.0f);
        Vec3 localTarget = targetPos.subtract(cannonPos);
        localTarget = localTarget.add(localTarget.normalize().scale((double)0.05f));
        CannonAccess.Restraint restraints = access.getPitchAndYawRestrains();
        IBallisticBehavior.Data ballistic = cannonTile.getTrajectoryData();
        float minPitch = restraints.minPitch() * ((float)Math.PI / 180);
        float maxPitch = restraints.maxPitch() * ((float)Math.PI / 180);
        Pair<Vec2, Float> vec3ToPoint = CannonUtils.vec3ToPoint2d(localTarget);
        Vec2 targetPoint = (Vec2)vec3ToPoint.getFirst();
        float initialYaw = ((Float)vec3ToPoint.getSecond()).floatValue();
        CannonTrajectory trajectory = CannonTrajectory.findBest(targetPoint, ballistic.gravity(), ballistic.drag(), cannonTile.getFirePower() * ballistic.initialSpeed(), shootingMode, minPitch, maxPitch);
        return Pair.of((Object)trajectory, (Object)Float.valueOf(initialYaw));
    }

    public static Vec3 point2dToVec3(Vec2 point, float yaw) {
        return new Vec3(0.0, (double)point.y, (double)(-point.x)).yRot(-yaw);
    }

    public static Pair<Vec2, Float> vec3ToPoint2d(Vec3 point) {
        float yaw = (float)Math.PI + (float)Mth.atan2((double)(-point.x), (double)point.z);
        Vec2 vec2 = new Vec2((float)Mth.length((double)point.x, (double)point.z), (float)point.y);
        return Pair.of((Object)vec2, (Object)Float.valueOf(yaw));
    }

    public static void spawnSmokeTrail(Level level, PoseStack poseStack, RandomSource ran, Vec3 sp) {
        int smokeCount = 40;
        for (int i = 0; i < smokeCount; ++i) {
            poseStack.pushPose();
            Vector4f speed = poseStack.last().pose().transform(new Vector4f(0.0f, 0.0f, -MthUtils.nextWeighted((RandomSource)ran, (float)0.5f, (float)1.0f, (float)0.06f), 0.0f));
            float aperture = 0.5f;
            poseStack.translate(-aperture / 2.0f + ran.nextFloat() * aperture, -aperture / 2.0f + ran.nextFloat() * aperture, 0.0f);
            Vector4f p = poseStack.last().pose().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)p.x, (double)p.y, (double)p.z, (double)speed.x + sp.x, (double)speed.y + sp.y, (double)speed.z + sp.z);
            poseStack.popPose();
        }
    }

    public static void spawnDustRing(Level level, PoseStack poseStack, Vec3 sp) {
        poseStack.pushPose();
        Vector4f p = poseStack.last().pose().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
        int dustCount = 16;
        for (int i = 0; i < dustCount; ++i) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(380.0f * (float)i / (float)dustCount));
            float vel = 0.05f;
            Vector4f speed = poseStack.last().pose().transform(new Vector4f(0.0f, 0.0f, vel, 0.0f));
            SimpleParticleType campfireCosySmoke = ModParticles.BOMB_SMOKE_PARTICLE.get();
            level.addParticle((ParticleOptions)campfireCosySmoke, (double)p.x, (double)p.y, (double)p.z, (double)speed.x + sp.x, (double)speed.y + sp.y, (double)speed.z + sp.z);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

