/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonTrajectoryRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CannonBlockTileRenderer
implements BlockEntityRenderer<CannonBlockTile> {
    private final ModelPart head;
    private final ModelPart legs;
    private final ModelPart pivot;
    private final ModelPart model;

    public CannonBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.bakeLayer(ClientRegistry.CANNON_MODEL);
        this.legs = model.getChild("legs");
        this.pivot = this.legs.getChild("head_pivot");
        this.head = this.pivot.getChild("head");
        this.model = model;
    }

    public int getViewDistance() {
        return 96;
    }

    public boolean shouldRenderOffScreen(CannonBlockTile blockEntity) {
        return true;
    }

    public void render(CannonBlockTile tile, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        CannonTrajectoryRenderer.render(tile, poseStack, bufferSource, packedLight, packedOverlay, partialTick);
        CannonBlockTileRenderer.renderCannonModel(this, tile, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public static void renderCannonModel(CannonBlockTileRenderer renderer, CannonBlockTile tile, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float scale;
        poseStack.pushPose();
        Quaternionf rotation = ((Direction)tile.getBlockState().getValue((Property)CannonBlock.FACING)).getOpposite().getRotation();
        poseStack.mulPose(rotation);
        VertexConsumer builder = ModMaterials.CANNON_MATERIAL.buffer(bufferSource, RenderType::entityCutout);
        float pitchRad = tile.getPitch(partialTick) * ((float)Math.PI / 180);
        float yawRad = tile.getYaw(partialTick) * ((float)Math.PI / 180);
        Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
        forward.rotateX((float)Math.PI - pitchRad);
        forward.rotateY((float)Math.PI - yawRad);
        forward.rotate((Quaternionfc)rotation.invert());
        yawRad = (float)Mth.atan2((double)forward.x, (double)forward.z);
        pitchRad = (float)Mth.atan2((double)(-forward.y), (double)Mth.sqrt((float)(forward.x * forward.x + forward.z * forward.z)));
        renderer.legs.yRot = yawRad;
        renderer.pivot.xRot = pitchRad;
        renderer.pivot.zRot = 0.0f;
        float cooldownCounter = tile.getCooldownAnimation(partialTick);
        float fireCounter = tile.getFiringAnimation(partialTick);
        float squish = CannonBlockTileRenderer.triangle(1.0f - cooldownCounter, 0.01f, 0.15f) * 0.2f;
        float wobble = Mth.sin((float)(fireCounter * 20.0f * (float)Math.PI)) * 0.005f;
        renderer.head.xScale = scale = wobble + 1.0f + squish * 0.7f;
        renderer.head.yScale = scale;
        renderer.head.zScale = 1.0f - squish;
        renderer.head.z = squish * 5.675f;
        renderer.model.render(poseStack, builder, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public static float triangle(float cooldownCounter, float mid, float end) {
        if (cooldownCounter <= mid) {
            float slope = 1.0f / mid;
            return slope * cooldownCounter;
        }
        if (cooldownCounter <= end) {
            float slope = -1.0f / (end - mid);
            return slope * (cooldownCounter - mid) + 1.0f;
        }
        return 0.0f;
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition legs = partdefinition.addOrReplaceChild("legs", CubeListBuilder.create().texOffs(0, 0).addBox(6.0f, -4.0f, -3.0f, 2.0f, 10.0f, 6.0f).texOffs(48, 0).addBox(-8.0f, -4.0f, -3.0f, 2.0f, 10.0f, 6.0f), PartPose.ZERO);
        PartDefinition head = legs.addOrReplaceChild("head_pivot", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bone = head.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 46).addBox(-6.0f, -6.0f, -6.5f, 12.0f, 12.0f, 6.0f).texOffs(0, 18).addBox(-6.0f, -6.0f, -6.5f, 12.0f, 12.0f, 13.0f, new CubeDeformation(-0.3125f)), PartPose.ZERO);
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, 6.0f, -8.0f, 16.0f, 2.0f, 16.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

