/*
 * Decompiled with CFR 0.152.
 */
package net.jaspr.fasterladderclimbing;

import com.mojang.logging.LogUtils;
import net.jaspr.fasterladderclimbing.FasterLadderClimbingConfig;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;

@Mod(value="fasterladderclimbing", dist={Dist.CLIENT})
public class FasterLadderClimbing {
    public static final String MOD_ID = "fasterladderclimbing";
    public static final Logger LOGGER = LogUtils.getLogger();

    public FasterLadderClimbing(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)FasterLadderClimbingConfig.CONFIG_SPEC);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        NeoForge.EVENT_BUS.addListener(FasterLadderClimbing::adjustClimbingSpeed);
    }

    private static void adjustClimbingSpeed(PlayerTickEvent.Pre event) {
        Player player;
        if (event.getEntity().level().isClientSide && (player = event.getEntity()).onClimbable() && !player.isCrouching()) {
            EntityClimber climber = new EntityClimber(player);
            if (((Boolean)FasterLadderClimbingConfig.allowQuickDescension.get()).booleanValue() && climber.isFacingDownward() && !climber.isMovingForward() && !climber.isMovingBackward()) {
                climber.moveDownFarther();
            } else if (((Boolean)FasterLadderClimbingConfig.allowQuickAscension.get()).booleanValue() && climber.isFacingUpward() && climber.isMovingForward()) {
                climber.moveUpFarther();
            }
        }
    }

    private static class EntityClimber {
        private Player player;

        public EntityClimber(Player player) {
            this.player = player;
        }

        private boolean isFacingDownward() {
            return this.player.getXRot() > 0.0f;
        }

        private boolean isFacingUpward() {
            return this.player.getXRot() < 0.0f;
        }

        private boolean isMovingForward() {
            return this.player.zza > 0.0f;
        }

        private boolean isMovingBackward() {
            return this.player.zza < 0.0f;
        }

        private float getElevationChangeUpdate() {
            return (float)Math.abs((double)this.player.getXRot() / 90.0) * ((float)((Integer)FasterLadderClimbingConfig.speedModifier.get()).intValue() / 10.0f);
        }

        public void moveUpFarther() {
            boolean px = false;
            float dx = this.getElevationChangeUpdate();
            Vec3 move = new Vec3((double)px, (double)dx, (double)px);
            this.player.move(MoverType.SELF, move);
        }

        public void moveDownFarther() {
            boolean px = false;
            float dx = this.getElevationChangeUpdate();
            Vec3 move = new Vec3((double)px, (double)(dx * -1.0f), (double)px);
            this.player.move(MoverType.SELF, move);
        }
    }
}

