/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.datagen.providers;

import com.autovw.advancednetherite.AdvancedNetherite;
import com.autovw.advancednetherite.core.ModBlocks;
import com.autovw.advancednetherite.core.ModItems;
import com.autovw.advancednetherite.core.util.ModTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(packOutput, completableFuture);
    }

    protected void buildRecipes(RecipeOutput output) {
        ModRecipeProvider.baseBlockRecipe(output, (ItemLike)ModItems.NETHERITE_IRON_INGOT, ModBlocks.NETHERITE_IRON_BLOCK);
        ModRecipeProvider.baseBlockRecipe(output, (ItemLike)ModItems.NETHERITE_GOLD_INGOT, ModBlocks.NETHERITE_GOLD_BLOCK);
        ModRecipeProvider.baseBlockRecipe(output, (ItemLike)ModItems.NETHERITE_EMERALD_INGOT, ModBlocks.NETHERITE_EMERALD_BLOCK);
        ModRecipeProvider.baseBlockRecipe(output, (ItemLike)ModItems.NETHERITE_DIAMOND_INGOT, ModBlocks.NETHERITE_DIAMOND_BLOCK);
        ModRecipeProvider.baseIngotRecipe(output, ModTags.INGOTS_UPGRADE_TO_NETHERITE_IRON, (TagKey<Item>)Tags.Items.INGOTS_IRON, ModItems.NETHERITE_IRON_INGOT);
        ModRecipeProvider.baseIngotRecipe(output, ModTags.INGOTS_UPGRADE_TO_NETHERITE_GOLD, (TagKey<Item>)Tags.Items.INGOTS_GOLD, ModItems.NETHERITE_GOLD_INGOT);
        ModRecipeProvider.baseIngotRecipe(output, ModTags.INGOTS_UPGRADE_TO_NETHERITE_EMERALD, (TagKey<Item>)Tags.Items.GEMS_EMERALD, ModItems.NETHERITE_EMERALD_INGOT);
        ModRecipeProvider.baseIngotRecipe(output, ModTags.INGOTS_UPGRADE_TO_NETHERITE_DIAMOND, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, ModItems.NETHERITE_DIAMOND_INGOT);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.AXE_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_AXE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.AXE_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_AXE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.AXE_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_AXE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.AXE_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_AXE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.BOOTS_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_BOOTS);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.BOOTS_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_BOOTS);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.BOOTS_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_BOOTS);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.BOOTS_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_BOOTS);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.CHESTPLATE_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_CHESTPLATE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.CHESTPLATE_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_CHESTPLATE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.CHESTPLATE_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_CHESTPLATE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.CHESTPLATE_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_CHESTPLATE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.HELMET_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_HELMET);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.HELMET_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_HELMET);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.HELMET_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_HELMET);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.HELMET_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_HELMET);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.HOE_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_HOE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.HOE_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_HOE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.HOE_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_HOE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.HOE_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_HOE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.LEGGINGS_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_LEGGINGS);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.LEGGINGS_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_LEGGINGS);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.LEGGINGS_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_LEGGINGS);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.LEGGINGS_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_LEGGINGS);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.PICKAXE_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_PICKAXE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.PICKAXE_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_PICKAXE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.PICKAXE_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_PICKAXE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.PICKAXE_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_PICKAXE);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.SHOVEL_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_SHOVEL);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.SHOVEL_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_SHOVEL);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.SHOVEL_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_SHOVEL);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.SHOVEL_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_SHOVEL);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.SWORD_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_SWORD);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.SWORD_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_SWORD);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.SWORD_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_SWORD);
        ModRecipeProvider.baseSmithingRecipe(output, ModTags.SWORD_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_SWORD);
        ModRecipeProvider.lodestoneRecipe(output);
    }

    public static void baseSmithingRecipe(RecipeOutput output, TagKey<Item> ingredient, TagKey<Item> upgradeIngredient, Item result) {
        ResourceLocation resultId = AdvancedNetherite.getRegistryHelper().getItemById(result);
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of(ingredient), (Ingredient)Ingredient.of(upgradeIngredient), (RecipeCategory)RecipeCategory.MISC, (Item)result).unlocks("has_ingredients", ModRecipeProvider.has(upgradeIngredient)).save(output, ResourceLocation.fromNamespaceAndPath((String)resultId.getNamespace(), (String)(resultId.getPath() + "_smithing")));
    }

    public static void baseIngotRecipe(RecipeOutput output, TagKey<Item> ingotIngredient, TagKey<Item> upgradeIngredient, Item result) {
        ResourceLocation resultId = AdvancedNetherite.getRegistryHelper().getItemById(result);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).requires(ingotIngredient).requires(upgradeIngredient).requires(upgradeIngredient).requires(upgradeIngredient).requires(upgradeIngredient).unlockedBy("has_" + upgradeIngredient.toString(), ModRecipeProvider.has(upgradeIngredient)).save(output, resultId);
    }

    public static void baseBlockRecipe(RecipeOutput output, ItemLike ingredient, Block result) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).define(Character.valueOf('#'), ingredient).pattern("###").pattern("###").pattern("###").unlockedBy("has_" + ingredient.toString(), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingredient, (int)9).requires((ItemLike)result).unlockedBy("has_" + result.toString(), ModRecipeProvider.has((ItemLike)result)).save(output, ResourceLocation.parse((String)(ingredient.toString() + "_from_block")));
    }

    private static void lodestoneRecipe(RecipeOutput output) {
        ResourceLocation lodestoneId = AdvancedNetherite.getRegistryHelper().getItemById(Items.LODESTONE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LODESTONE).define(Character.valueOf('S'), (ItemLike)Items.CHISELED_STONE_BRICKS).define(Character.valueOf('#'), ModTags.NETHERITE_INGOTS).pattern("SSS").pattern("S#S").pattern("SSS").unlockedBy("has_chiseled_stone_bricks", ModRecipeProvider.has((ItemLike)Items.CHISELED_STONE_BRICKS)).unlockedBy("has_netherite_ingots", ModRecipeProvider.has(ModTags.NETHERITE_INGOTS)).save(output, ResourceLocation.fromNamespaceAndPath((String)"advancednetherite", (String)lodestoneId.getPath()));
    }
}

