/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.item;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.common.AdvancedUtil;
import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.util.ModTags;
import com.autovw.advancednetherite.core.util.ModTooltips;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class AdvancedArmorItem
extends ArmorItem {
    private final Holder<ArmorMaterial> material;

    public AdvancedArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type armorType, Item.Properties properties) {
        super(material, armorType, properties);
        this.material = material;
    }

    @Internal
    public AdvancedArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type armorType) {
        this(material, armorType, new Item.Properties().durability(armorType.getDurability(AdvancedUtil.getArmorDurabilityMultiplier(material))).fireResistant());
    }

    @Deprecated(forRemoval=true, since="2.2.0")
    public boolean pacifiesEndermen() {
        return false;
    }

    public boolean pacifiesEndermen(ItemStack stack) {
        return stack.is(ModTags.PACIFY_ENDERMEN_ARMOR);
    }

    @Deprecated(forRemoval=true, since="2.2.0")
    public boolean pacifiesPiglins() {
        return false;
    }

    public boolean pacifiesPiglins(ItemStack stack) {
        return stack.is(ModTags.PACIFY_PIGLINS_ARMOR);
    }

    @Deprecated(forRemoval=true, since="2.2.0")
    public boolean pacifiesPhantoms() {
        return false;
    }

    public boolean pacifiesPhantoms(ItemStack stack) {
        return stack.is(ModTags.PACIFY_PHANTOMS_ARMOR);
    }

    public void addTooltips(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flag) {
    }

    public ChatFormatting customDurabilityBarColor(ItemStack stack) {
        return null;
    }

    @Internal
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (ConfigHelper.get().getClient().showTooltips()) {
            if (Screen.hasShiftDown()) {
                if (this.pacifiesEndermen(stack)) {
                    tooltip.add((Component)ModTooltips.ENDERMAN_PASSIVE_TOOLTIP);
                }
                if (this.pacifiesPiglins(stack)) {
                    tooltip.add((Component)ModTooltips.PIGLIN_PASSIVE_TOOLTIP);
                }
                if (this.pacifiesPhantoms(stack)) {
                    tooltip.add((Component)ModTooltips.PHANTOM_PASSIVE_TOOLTIP);
                }
            } else if (this.pacifiesEndermen(stack) || this.pacifiesPiglins(stack) || this.pacifiesPhantoms(stack)) {
                tooltip.add((Component)ModTooltips.SHIFT_KEY_TOOLTIP);
            }
            this.addTooltips(stack, context, tooltip, flag);
        }
    }

    @Internal
    public int getBarColor(ItemStack stack) {
        int originalColor = super.getBarColor(stack);
        if (this.customDurabilityBarColor(stack) != null && ConfigHelper.get().getClient().matchingDurabilityBars()) {
            return Objects.requireNonNull(this.customDurabilityBarColor(stack).getColor());
        }
        return AdvancedUtil.getDurabilityBarColor(originalColor, stack);
    }
}

