/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.mixin.required.yacl;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.qendolin.betterclouds.compat.ReflectAccess;
import com.qendolin.betterclouds.compat.YACLCompat;
import com.qendolin.betterclouds.duck.CustomCategoryTabDuck;
import com.qendolin.betterclouds.duck.CustomOptionListWidgetDuck;
import com.qendolin.betterclouds.gui.ConfigScreen;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={YACLScreen.CategoryTab.class}, remap=false)
public abstract class CategoryTabMixin
implements CustomCategoryTabDuck {
    @Shadow
    @Final
    private YACLScreen screen;
    @Shadow
    @Final
    public Button undoButton;
    @Shadow
    @Final
    public Button cancelResetButton;
    @Shadow
    @Final
    public Button saveFinishedButton;
    @Unique
    private boolean override;
    @Unique
    private Button hideShowButton;

    @Shadow
    public abstract void updateButtons();

    @Override
    public void betterclouds$applyOverride() {
        this.undoButton.active = false;
        this.undoButton.visible = false;
        this.override = true;
        try {
            Field optionListField = this.getClass().getDeclaredField("optionList");
            optionListField.setAccessible(true);
            Object optionList = optionListField.get(this);
            Method getListMethod = YACLCompat.isVersion3_8_0() ? optionList.getClass().getDeclaredMethod("getType", new Class[0]) : optionList.getClass().getDeclaredMethod("getList", new Class[0]);
            getListMethod.setAccessible(true);
            Object optionListObject = getListMethod.invoke(optionList, new Object[0]);
            ((CustomOptionListWidgetDuck)optionListObject).betterclouds$applyOverride();
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectAccess.IncompatibleModDependencyException("YACL", e);
        }
        Minecraft client = Minecraft.getInstance();
        this.hideShowButton = Button.builder((Component)Component.translatable((String)"betterclouds.config.hide"), btn -> this.hideOrShow()).pos(this.undoButton.getX(), this.undoButton.getY()).size(this.undoButton.getWidth(), this.undoButton.getHeight()).build();
        this.hideShowButton.active = client.level != null;
    }

    @Unique
    private void hideOrShow() {
        Minecraft client = Minecraft.getInstance();
        if (client.screen == this.screen) {
            this.hideShowButton.setMessage((Component)Component.translatable((String)"betterclouds.config.show"));
            ConfigScreen.HiddenScreen hiddenScreen = new ConfigScreen.HiddenScreen(this.screen.getTitle(), this.hideShowButton);
            client.setScreen((Screen)hiddenScreen);
        } else {
            this.hideShowButton.setMessage((Component)Component.translatable((String)"betterclouds.config.hide"));
            client.setScreen((Screen)this.screen);
        }
    }

    @WrapMethod(method={"updateButtons()V"})
    private void updateButtons(Operation<Void> original) {
        if (!this.override) {
            original.call(new Object[0]);
            return;
        }
        boolean pendingChanges = this.screen.pendingChanges();
        if (Screen.hasShiftDown()) {
            this.cancelResetButton.active = true;
            this.cancelResetButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"betterclouds.config.reset.tooltip")));
        } else {
            this.cancelResetButton.active = false;
            this.cancelResetButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"betterclouds.config.reset.tooltip.holdShift")));
        }
        this.cancelResetButton.setMessage((Component)(pendingChanges ? GuiUtils.translatableFallback((String)"yacl.gui.cancel", (Component)CommonComponents.GUI_CANCEL) : Component.translatable((String)"controls.reset")));
        this.saveFinishedButton.setMessage((Component)(pendingChanges ? Component.translatable((String)"yacl.gui.save") : GuiUtils.translatableFallback((String)"yacl.gui.done", (Component)CommonComponents.GUI_DONE)));
        this.saveFinishedButton.setTooltip(Tooltip.create((Component)(pendingChanges ? Component.translatable((String)"yacl.gui.save.tooltip") : Component.translatable((String)"yacl.gui.finished.tooltip"))));
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        if (!this.override) {
            return;
        }
        this.updateButtons();
    }

    @Inject(method={"visitChildren(Ljava/util/function/Consumer;)V"}, at={@At(value="TAIL")}, remap=true)
    private void onForEachChild(Consumer<AbstractWidget> consumer, CallbackInfo ci) {
        if (!this.override) {
            return;
        }
        consumer.accept((AbstractWidget)this.hideShowButton);
    }
}

