/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawConfig;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawGenerator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import org.jetbrains.annotations.NotNull;

public class AlternateJigsawStructure
extends Structure {
    public static final MapCodec<AlternateJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AlternateJigsawStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)AlternateJigsawConfig.CODEC.forGetter(AlternateJigsawStructure::config)).apply((Applicative)instance, AlternateJigsawStructure::new)).validate(AlternateJigsawStructure::validate);
    public static final StructureType<AlternateJigsawStructure> TYPE = () -> CODEC;
    private AlternateJigsawConfig config;

    private static DataResult<AlternateJigsawStructure> validate(AlternateJigsawStructure structure) {
        int i = switch (structure.terrainAdaptation()) {
            default -> throw new MatchException(null, null);
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX, TerrainAdjustment.ENCAPSULATE -> 12;
        };
        return structure.config().maxDistanceFromCenter().horizontal() + i > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)((Object)structure));
    }

    protected AlternateJigsawStructure(Structure.StructureSettings settings, AlternateJigsawConfig config) {
        super(settings);
        this.config = config;
    }

    public void setPoolAliases(List<PoolAliasBinding> poolAliases, boolean append) {
        this.config = this.config.setPoolAliases(poolAliases, append);
    }

    public AlternateJigsawConfig config() {
        return this.config;
    }

    @NotNull
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        int i = this.config.startHeight().sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        BlockPos blockPos = new BlockPos(chunkPos.getMinBlockX(), i, chunkPos.getMinBlockZ());
        return AlternateJigsawStructure.generate(context, this.config, false, this.config.size().sample((RandomSource)context.random()), blockPos, PoolAliasLookup.create(this.config.poolAliases(), (BlockPos)blockPos, (long)context.seed()));
    }

    public static Optional<Structure.GenerationStub> generate(Structure.GenerationContext context, AlternateJigsawConfig config, boolean vanilla, int size, BlockPos pos, PoolAliasLookup aliasLookup) {
        return AlternateJigsawGenerator.generate(context, config, vanilla, size, pos, aliasLookup);
    }

    @NotNull
    public StructureType<?> type() {
        return TYPE;
    }
}

