/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.register;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllSoundEvents;
import dev.lopyluna.dndesires.DnDesires;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

public class DesiresSoundEvents {
    public static final Map<ResourceLocation, AllSoundEvents.SoundEntry> ALL = new HashMap<ResourceLocation, AllSoundEvents.SoundEntry>();
    public static final AllSoundEvents.SoundEntry FLUID_HATCH = DesiresSoundEvents.create("fluid_hatch").subtitle("Fluid Hatch opens").playExisting(SoundEvents.COPPER_DOOR_OPEN, 0.25f, 0.7f).playExisting(SoundEvents.COPPER_PLACE, 0.75f, 1.15f).category(SoundSource.BLOCKS).build();

    private static DnDesiresSoundEntryBuilder create(String name) {
        return DesiresSoundEvents.create(DnDesires.loc(name));
    }

    public static DnDesiresSoundEntryBuilder create(ResourceLocation id) {
        return new DnDesiresSoundEntryBuilder(id);
    }

    public static void prepare() {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            entry.prepare();
        }
    }

    public static void register(RegisterEvent event) {
        event.register(Registries.SOUND_EVENT, helper -> ALL.values().forEach(entry -> entry.register(helper)));
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            consumer.accept(entry.getSubtitleKey(), entry.getSubtitle());
        }
    }

    public static SoundEntryProvider provider(DataGenerator generator) {
        return new SoundEntryProvider(generator);
    }

    public static class DnDesiresSoundEntryBuilder
    extends AllSoundEvents.SoundEntryBuilder {
        public DnDesiresSoundEntryBuilder(ResourceLocation id) {
            super(id);
        }

        public DnDesiresSoundEntryBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public DnDesiresSoundEntryBuilder attenuationDistance(int distance) {
            this.attenuationDistance = distance;
            return this;
        }

        public DnDesiresSoundEntryBuilder noSubtitle() {
            this.subtitle = null;
            return this;
        }

        public DnDesiresSoundEntryBuilder category(SoundSource category) {
            this.category = category;
            return this;
        }

        public DnDesiresSoundEntryBuilder addVariant(String name) {
            return this.addVariant(DnDesires.loc(name));
        }

        public DnDesiresSoundEntryBuilder addVariant(ResourceLocation id) {
            this.variants.add(id);
            return this;
        }

        public DnDesiresSoundEntryBuilder playExisting(Supplier<SoundEvent> event, float volume, float pitch) {
            this.wrappedEvents.add(new AllSoundEvents.ConfiguredSoundEvent(event, volume, pitch));
            return this;
        }

        public DnDesiresSoundEntryBuilder playExisting(SoundEvent event, float volume, float pitch) {
            return this.playExisting(() -> event, volume, pitch);
        }

        public DnDesiresSoundEntryBuilder playExisting(SoundEvent event) {
            return this.playExisting(event, 1.0f, 1.0f);
        }

        public DnDesiresSoundEntryBuilder playExisting(Holder<SoundEvent> event) {
            return this.playExisting(() -> event.value(), 1.0f, 1.0f);
        }

        public AllSoundEvents.SoundEntry build() {
            AllSoundEvents.SoundEntry entry = super.build();
            ALL.put(entry.getId(), entry);
            AllSoundEvents.ALL.remove(entry.getId());
            return entry;
        }
    }

    public static class SoundEntryProvider
    implements DataProvider {
        private final PackOutput output;

        public SoundEntryProvider(DataGenerator generator) {
            this.output = generator.getPackOutput();
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput cache) {
            return this.generate(this.output.getOutputFolder(), cache);
        }

        @NotNull
        public String getName() {
            return "DnDesires's Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, CachedOutput cache) {
            path = path.resolve("assets/dndesires");
            JsonObject json = new JsonObject();
            ALL.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((AllSoundEvents.SoundEntry)entry.getValue()).write(json));
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }
}

