/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item.rule.file;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.anti_ad.mc.common.TellPlayer;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.item.rule.EmptyRule;
import org.anti_ad.mc.ipnext.item.rule.Parameter;
import org.anti_ad.mc.ipnext.item.rule.Rule;
import org.anti_ad.mc.ipnext.item.rule.file.CustomRule;
import org.anti_ad.mc.ipnext.item.rule.file.RuleDefinition;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFile;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFileRegister$RuleFinder;
import org.anti_ad.mc.ipnext.item.rule.natives.NativeRules;
import org.anti_ad.mc.ipnext.item.rule.parameter.NativeParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRuleFileRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuleFileRegister.kt\norg/anti_ad/mc/ipnext/item/rule/file/RuleFileRegister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 kt_common.kt\norg/anti_ad/mc/common/extensions/Kt_commonKt\n*L\n1#1,209:1\n1869#2,2:210\n1#3:212\n1#3:214\n130#4:213\n*S KotlinDebug\n*F\n+ 1 RuleFileRegister.kt\norg/anti_ad/mc/ipnext/item/rule/file/RuleFileRegister\n*L\n53#1:210,2\n141#1:214\n141#1:213\n*E\n"})
public final class RuleFileRegister {
    @NotNull
    public static final RuleFileRegister INSTANCE = new RuleFileRegister();
    @NotNull
    private static final Set loadedFileNames = new LinkedHashSet();
    @NotNull
    private static final List ruleFiles = new ArrayList();
    @NotNull
    private static final Map cachedRules = new LinkedHashMap();
    @NotNull
    private static final Set names = new LinkedHashSet();

    private RuleFileRegister() {
    }

    @NotNull
    public final Set getLoadedFileNames() {
        return loadedFileNames;
    }

    public final void reloadRuleFiles(@NotNull List list, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"");
        Log.INSTANCE.trace("[-] Rule file parsing...");
        Log.INSTANCE.trace("    step: (1) parse indent -> (2) parse rule -> syntax ok");
        Log.INSTANCE.indent();
        for (RuleFile ruleFile : (Iterable)list) {
            if (bl) {
                TellPlayer.INSTANCE.chat("Parsing custom rules file " + ruleFile.getFileName());
            }
            ruleFile.parseContent();
        }
        Log.INSTANCE.unindent();
        this.clear();
        ruleFiles.addAll(list);
        this.checkOverrides(bl);
        this.validateRules(bl);
    }

    private final void clear() {
        loadedFileNames.clear();
        ruleFiles.clear();
        cachedRules.clear();
        names.clear();
    }

    private final void checkOverrides(boolean bl) {
        Log.INSTANCE.trace("[-] Check overrides...");
        for (RuleFile ruleFile : ruleFiles) {
            for (String string : ruleFile.getRulesMap().keySet()) {
                if (names.contains(string)) {
                    if (bl) {
                        TellPlayer.INSTANCE.chat("Rule @" + string + " already defined in another file. Overriding with file " + ruleFile.getFileName());
                    }
                    Log.INSTANCE.info("Rule @" + string + " overrode by file " + ruleFile.getFileName());
                }
                names.add(string);
            }
        }
    }

    private final void validateRules(boolean bl) {
        Log.INSTANCE.trace("[-] Validate rules...");
        Log.INSTANCE.indent();
        for (String string : names) {
            Log.INSTANCE.trace("[-] Validating rule @" + string);
            Log.INSTANCE.indent();
            if (this.getCustomRule(string, bl) == null) {
                Function0 cfr_ignored_0 = () -> RuleFileRegister.validateRules$lambda$1(bl, string);
            }
            Log.INSTANCE.unindent();
        }
        Log.INSTANCE.unindent();
    }

    @NotNull
    public final Rule getCustomRuleOrEmpty(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        CustomRule customRule = this.getCustomRule(string, false);
        if (customRule != null) {
            return customRule;
        }
        EmptyRule emptyRule = EmptyRule.INSTANCE;
        Log.INSTANCE.warn("Rule @" + string + " not found");
        return emptyRule;
    }

    @Nullable
    public final CustomRule getCustomRule(@NotNull String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        RuleDefinition ruleDefinition = cachedRules.containsKey(string) ? (RuleDefinition)MapsKt.getValue((Map)cachedRules, (Object)string) : this.searchAndPutCustomRule(string, bl);
        if (ruleDefinition != null) {
            return ruleDefinition.createCustomRule();
        }
        return null;
    }

    @Nullable
    public final Rule getNativeRule(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Function0 function0 = (Function0)NativeRules.INSTANCE.getMap().get(string);
        if (function0 != null) {
            return (Rule)function0.invoke();
        }
        return null;
    }

    @Nullable
    public final Parameter getParameter(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return (Parameter)NativeParameters.INSTANCE.getMap().get(string);
    }

    private final RuleDefinition searchAndPutCustomRule(String string, boolean bl) {
        Log.INSTANCE.trace("[-] Searching rule @" + string + "...");
        Log.INSTANCE.indent();
        RuleDefinition ruleDefinition = new RuleFileRegister$RuleFinder(string, bl).searchCustomRule();
        Log.INSTANCE.unindent();
        if (cachedRules.containsKey(string)) {
            Log.INSTANCE.trace(">> rule " + string + " already exist in cached map... skip putting");
        } else {
            cachedRules.put(string, ruleDefinition);
        }
        CollectionsKt.removeAll((List)ruleFiles, RuleFileRegister::searchAndPutCustomRule$lambda$4);
        return ruleDefinition;
    }

    private static final Unit validateRules$lambda$1(boolean bl, String string) {
        if (bl) {
            TellPlayer.INSTANCE.chat("Failed to process Rule '@" + string + "'");
        }
        Log.INSTANCE.debug("rule @" + string + " failed to parse");
        return Unit.INSTANCE;
    }

    private static final boolean searchAndPutCustomRule$lambda$4(RuleFile ruleFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ruleFile, (String)"");
        boolean bl2 = bl = ruleFile.getRulesMap().isEmpty();
        if (bl) {
            Log.INSTANCE.trace("Remove validated file " + ruleFile.getFileName());
        }
        return bl2;
    }

    public static final /* synthetic */ List access$getRuleFiles$p() {
        return ruleFiles;
    }
}

