/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CheckboxButtonEx
extends AbstractButton {
    private static final WidgetSprites CHECKBOX_TEXTURES = new WidgetSprites(ResourceLocation.parse((String)"fpsreducer:checkbox/box_enabled"), ResourceLocation.parse((String)"fpsreducer:checkbox/box_disabled"), ResourceLocation.parse((String)"fpsreducer:checkbox/box_enabled_highlighted"), ResourceLocation.parse((String)"fpsreducer:checkbox/box_disabled_highlighted"));
    protected final IPressable onPress;
    private boolean checked;

    public CheckboxButtonEx(int x, int y, int w, int h, Component msg, boolean isChecked, IPressable onPress) {
        super(x, y, w, h, msg);
        this.onPress = onPress;
        this.checked = isChecked;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            Minecraft mc = Minecraft.getInstance();
            RenderSystem.enableDepthTest();
            Font fontrenderer = mc.font;
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            int i = this.getYImage(this.isHovered());
            guiGraphics.blitSprite(CHECKBOX_TEXTURES.get(this.isChecked(), this.isHoveredOrFocused()), this.getX(), this.getY(), this.width, this.height);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            int j = this.active ? 0xFFFFFF : 0xA0A0A0;
            this.renderString(guiGraphics, fontrenderer, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
            int color = 0xE0E0E0;
            if (!this.active) {
                color = 0xA0A0A0;
            }
            guiGraphics.drawString(fontrenderer, this.getMessage(), this.getX() + this.width + 2, this.getY() + 2, color);
        }
    }

    protected int getYImage(boolean hovered) {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (hovered) {
            i = 2;
        }
        return i;
    }

    public void onPress() {
        this.onPress.onPress(this);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setIsChecked(boolean check) {
        this.checked = check;
    }

    public void updateWidgetNarration(NarrationElementOutput narration) {
        narration.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narration.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                narration.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPress(CheckboxButtonEx var1);
    }
}

