/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util.biome;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import me.pepperbell.continuity.client.util.biome.BiomeHolder;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public final class BiomeHolderManager {
    private static final Map<ResourceLocation, BiomeHolder> HOLDER_CACHE = new Object2ObjectOpenHashMap();
    private static final Set<Runnable> REFRESH_CALLBACKS = new ReferenceOpenHashSet();
    private static RegistryAccess registryManager;

    public static BiomeHolder getOrCreateHolder(ResourceLocation id) {
        return HOLDER_CACHE.computeIfAbsent(id, BiomeHolder::new);
    }

    public static void addRefreshCallback(Runnable callback) {
        REFRESH_CALLBACKS.add(callback);
    }

    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            registryManager = handler.registryAccess();
            BiomeHolderManager.refreshHolders();
        });
    }

    public static void refreshHolders() {
        if (registryManager == null) {
            return;
        }
        Object2ObjectOpenHashMap compactIdMap = new Object2ObjectOpenHashMap();
        Registry biomeRegistry = registryManager.registryOrThrow(Registries.BIOME);
        for (ResourceLocation id : biomeRegistry.keySet()) {
            ResourceLocation compactId;
            String compactPath;
            String path = id.getPath();
            if (path.equals(compactPath = path.replace("_", "")) || biomeRegistry.containsKey(compactId = id.withPath(compactPath))) continue;
            compactIdMap.put(compactId, id);
        }
        for (BiomeHolder holder : HOLDER_CACHE.values()) {
            holder.refresh((Registry<Biome>)biomeRegistry, (Map<ResourceLocation, ResourceLocation>)compactIdMap);
        }
        for (Runnable callback : REFRESH_CALLBACKS) {
            callback.run();
        }
    }

    public static void clearCache() {
        HOLDER_CACHE.clear();
        REFRESH_CALLBACKS.clear();
    }
}

