/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class SearchTrie<K, O> {
    protected final TrieNode<K, O> root = new TrieNode();

    public void insert(List<K> paths, O object) {
        TrieNode<K, O> current = this.root;
        for (K folder : paths) {
            current.children.putIfAbsent(folder, new TrieNode());
            current = current.children.get(folder);
        }
        current.objects.add(object);
    }

    public Collection<O> search(List<K> paths) {
        TrieNode<K, O> current = this.getNode(paths);
        if (current == null) {
            return Collections.emptyList();
        }
        return current.collectObjects();
    }

    public boolean remove(List<K> path) {
        TrieNode<K, O> current = this.getNode(path);
        if (current == null) {
            return false;
        }
        current.children.clear();
        current.objects.clear();
        return true;
    }

    @Nullable
    protected TrieNode<K, O> getNode(List<K> path) {
        TrieNode<K, O> current = this.root;
        for (K key : path) {
            current = current.children.getOrDefault(key, current.children.get(null));
            if (current != null) continue;
            return null;
        }
        return current;
    }

    public void clear() {
        this.root.children.clear();
        this.root.objects.clear();
    }

    public Collection<K> listKeys(List<K> path) {
        TrieNode<K, O> startNode = this.getNode(path);
        if (startNode != null) {
            return startNode.children.keySet();
        }
        return Collections.emptyList();
    }

    public void printTrie() {
        this.printTrie(Logger.getGlobal());
    }

    public void printTrie(Logger logger) {
        this.printNode(logger, this.root, "", "root", true);
    }

    private void printNode(Logger logger, TrieNode<K, O> node, String prefix, String nodeName, boolean isTail) {
        if (!node.objects.isEmpty()) {
            logger.info(prefix + (isTail ? "\\--- " : "|--- ") + nodeName + " " + String.valueOf(node.objects));
        } else {
            logger.info(prefix + (isTail ? "\\--- " : "|--- ") + nodeName + " (empty)");
        }
        ArrayList childrenKeys = new ArrayList(node.children.keySet());
        for (int i = 0; i < childrenKeys.size(); ++i) {
            Object key = childrenKeys.get(i);
            TrieNode childNode = node.children.get(key);
            boolean isLastChild = i == childrenKeys.size() - 1;
            String newPrefix = prefix + (isTail ? "    " : "|   ");
            this.printNode(logger, childNode, newPrefix, key.toString(), isLastChild);
        }
    }

    protected static class TrieNode<K, O> {
        Map<K, TrieNode<K, O>> children = new HashMap<K, TrieNode<K, O>>();
        List<O> objects = new ArrayList<O>();

        public List<O> collectObjects() {
            ArrayList<O> result = new ArrayList<O>(this.objects);
            for (TrieNode<K, O> child : this.children.values()) {
                result.addAll(child.collectObjects());
            }
            return result;
        }
    }
}

