/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.BooleanEntry;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.EnumEntry;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.ValueEntry;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import java.io.InvalidClassException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;

public interface QOLConfigurableItem {
    default public void invTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.doesEffectRequiresAir() && BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty()) {
            return;
        }
        if (this.type().equals((Object)Type.ARMOR)) {
            Item item = stack.getItem();
            if (!(item instanceof ArmorItem)) {
                throw new IllegalArgumentException(String.valueOf(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())) + " is defined with Type.ARMOR even if it isn't a ArmorItem");
            }
            ArmorItem it = (ArmorItem)item;
            ArmorItem.Type type = it.getType();
            if (player.getItemBySlot(type.getSlot()).equals(stack) && QOLConfigurableItem.hasEffectEnable(stack) && this.providedEffect(stack) != null && this.providedEffect(stack).value() != null) {
                QOLConfigurableItem.applyEffect(player, this.providedEffect(stack), this.effectTime(stack), this.effectLevel(stack));
                this.tick(stack, level, player, slot, offHand);
            }
        } else if (this.type().equals((Object)Type.ITEM) && (player.getItemInHand(InteractionHand.MAIN_HAND).equals(stack) || player.getItemInHand(InteractionHand.OFF_HAND).equals(stack)) && QOLConfigurableItem.hasEffectEnable(stack) && this.providedEffect(stack) != null && this.providedEffect(stack).value() != null) {
            QOLConfigurableItem.applyEffect(player, this.providedEffect(stack), this.effectTime(stack), this.effectLevel(stack));
            this.tick(stack, level, player, slot, offHand);
        }
    }

    default public void tick(ItemStack stack, Level level, Player player, int slot, boolean offHand) {
    }

    public static boolean hasEffectEnable(ItemStack stack) {
        return (Boolean)stack.getOrDefault(QOLDataComponents.ARMOR_EFFECT, (Object)true) != false && (Boolean)CreateQOLConfigs.server().equipments.armors.armorEffects.get() != false;
    }

    default public String effectAdditionInfos(ItemStack stack) {
        return "";
    }

    default public int effectLevel(ItemStack stack) {
        return 1;
    }

    default public int effectTime(ItemStack stack) {
        return 20;
    }

    public static void applyEffect(Player player, Holder<MobEffect> effect, int time, int level) {
        if (effect == null || effect.value() == null) {
            throw new RuntimeException(new IllegalAccessException("Trying to give a null effect to a player"));
        }
        player.addEffect(new MobEffectInstance(effect, time, level, false, false));
    }

    default public List<Configuration<?>> getConfigurations(ItemStack stack) throws InvalidClassException {
        ArrayList list = new ArrayList();
        if (this.providedEffect(stack) != null && this.providedEffect(stack).value() != null) {
            ArrayList<String> comments = new ArrayList<String>(Arrays.asList("Enable the potion effect granted by the item", "For this item, the effect is " + Component.translatable((String)((MobEffect)this.providedEffect(stack).value()).getDescriptionId()).getString()));
            if (!this.effectAdditionInfos(stack).isEmpty()) {
                comments.add(this.effectAdditionInfos(stack));
            }
            list.add(Configuration.ofBool("Apply Potion Effect", (Boolean)stack.getOrDefault(QOLDataComponents.ARMOR_EFFECT, (Object)true), QOLDataComponents.ARMOR_EFFECT, comments, (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.armorEffects.get()));
        }
        if (this.type().equals((Object)Type.ARMOR)) {
            if (this.renderTypes(stack) == null || this.renderTypes(stack).size() < 2) {
                throw new InvalidClassException("Configurable item with the armor type must declare at least 2 types of render types");
            }
            list.add(new Configuration<ArmorRenderType>("Render Type", (ArmorRenderType)((Object)stack.getOrDefault(QOLDataComponents.ARMOR_RENDER_TYPE, (Object)ArmorRenderType.ALL)), QOLDataComponents.ARMOR_RENDER_TYPE, Configuration.ConfigType.ENUM, Arrays.asList("Define how the armor piece should be rendered.", "\"Armor only\" renders only the armor", "\"Addition only\" renders only the additions (E.g. Backtank, Goggles)"), (direction, entry) -> {
                ArmorRenderType e = (ArmorRenderType)((Object)((Object)entry.getValue()));
                ArmorRenderType[] options = (ArmorRenderType[])Arrays.stream(ArmorRenderType.values()).filter(it -> this.renderTypes(stack).contains(it)).toArray(ArmorRenderType[]::new);
                e = options[Math.floorMod(e.ordinal() + direction, options.length)];
                return e;
            }, (e, oE) -> true));
        }
        if (this.reachType(stack) != ReachType.NONE) {
            boolean hasBlock = this.reachType((ItemStack)stack).attributes.contains(Attributes.BLOCK_INTERACTION_RANGE);
            boolean hasEntity = this.reachType((ItemStack)stack).attributes.contains(Attributes.ENTITY_INTERACTION_RANGE);
            list.add(Configuration.ofBool("Reach", (Boolean)stack.getOrDefault(QOLDataComponents.REACH, (Object)true), QOLDataComponents.REACH, Arrays.asList("Define if this item should give reach.", "This item multiplies your reach on " + (hasBlock ? "blocks" : "") + (hasBlock && hasEntity ? " and " : "") + (hasEntity ? "entities" : "") + " by " + (this.reachModifier(stack) + 1.0)), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.tools.reach.get()));
        }
        this.addConfigurations(list, stack);
        return list;
    }

    default public void addConfigurations(List<Configuration<?>> list, ItemStack stack) {
    }

    default public Holder<MobEffect> providedEffect(ItemStack stack) {
        return null;
    }

    public Type type();

    default public boolean doesEffectRequiresAir() {
        return true;
    }

    default public List<ArmorRenderType> renderTypes(ItemStack stack) {
        return null;
    }

    default public boolean appliesReach(ItemStack stack) {
        return (Boolean)CreateQOLConfigs.server().equipments.tools.reach.get() != false && (Boolean)stack.getOrDefault(QOLDataComponents.REACH, (Object)true) != false && this.reachType(stack) != ReachType.NONE;
    }

    default public ReachType reachType(ItemStack stack) {
        return ReachType.NONE;
    }

    default public double reachModifier(ItemStack stack) {
        return 0.5;
    }

    default public Map<Holder<Attribute>, Map.Entry<Double, AttributeModifier.Operation>> getAppliedAttributes(ItemStack stack) {
        HashMap<Holder<Attribute>, Map.Entry<Double, AttributeModifier.Operation>> attributes = new HashMap<Holder<Attribute>, Map.Entry<Double, AttributeModifier.Operation>>();
        if (this.appliesReach(stack)) {
            this.reachType(stack).getAttributes().forEach(a -> attributes.put((Holder<Attribute>)a, (Map.Entry<Double, AttributeModifier.Operation>)new AbstractMap.SimpleEntry<Double, AttributeModifier.Operation>(this.reachModifier(stack), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)));
        }
        return attributes;
    }

    public static void modifyAttributes(ItemAttributeModifierEvent event) {
        Item item = event.getItemStack().getItem();
        if (!(item instanceof QOLConfigurableItem)) {
            return;
        }
        QOLConfigurableItem it = (QOLConfigurableItem)item;
        Type type = it.type();
        if (type == Type.ARMOR) {
            Item item2 = event.getItemStack().getItem();
            if (!(item2 instanceof ArmorItem)) {
                throw new IllegalArgumentException(String.valueOf(BuiltInRegistries.ITEM.getKey((Object)event.getItemStack().getItem())) + " is defined with Type.ARMOR even if it isn't a ArmorItem");
            }
            ArmorItem ait = (ArmorItem)item2;
            ArmorItem.Type aType = ait.getType();
            ResourceLocation resourcelocation = CreateQOL.asResource("armors." + ait.getDescriptionId().split("\\.")[2]);
            it.getAppliedAttributes(event.getItemStack()).forEach((a, doe) -> event.addModifier(a, new AttributeModifier(resourcelocation, ((Double)doe.getKey()).doubleValue(), (AttributeModifier.Operation)doe.getValue()), EquipmentSlotGroup.bySlot((EquipmentSlot)aType.getSlot())));
        } else if (type == Type.ITEM) {
            TieredItem item3 = (TieredItem)event.getItemStack().getItem();
            ResourceLocation resourcelocation = CreateQOL.asResource("tools." + item3.getDescriptionId().split("\\.")[2]);
            it.getAppliedAttributes(event.getItemStack()).forEach((a, doe) -> event.addModifier(a, new AttributeModifier(resourcelocation, ((Double)doe.getKey()).doubleValue(), (AttributeModifier.Operation)doe.getValue()), EquipmentSlotGroup.HAND));
        }
    }

    public static Component chooseState(boolean config, boolean installed, boolean active, boolean activeReplaceInstall, boolean activeOnly) {
        if (activeOnly) {
            return Component.translatable((String)(!config ? "createqol.ability.state.disabled_by_config" : (active ? "createqol.ability.state.enabled" : "createqol.ability.state.disabled"))).withStyle(!config ? ChatFormatting.RED : ChatFormatting.YELLOW);
        }
        return Component.translatable((String)(!config ? "createqol.ability.state.disabled_by_config" : (installed ? (activeReplaceInstall ? (active ? "createqol.ability.state.enabled" : "createqol.ability.state.disabled") : "createqol.ability.state.installed") : "createqol.ability.state.not_installed"))).withStyle(!config ? ChatFormatting.RED : ChatFormatting.YELLOW);
    }

    public static Component cooldownState(boolean config, boolean active, int cooldown) {
        return !config ? Component.translatable((String)"createqol.ability.state.disabled_by_config").withStyle(ChatFormatting.RED) : (active ? (cooldown > 0 ? Component.literal((String)String.valueOf(cooldown / 20)).append((Component)Component.translatable((String)"createqol.ability.state.seconds")).withStyle(ChatFormatting.YELLOW) : Component.translatable((String)"createqol.ability.state.enabled")).withStyle(ChatFormatting.YELLOW) : Component.translatable((String)"createqol.ability.state.disabled")).withStyle(ChatFormatting.YELLOW);
    }

    public static enum Type {
        ARMOR,
        ITEM;

    }

    public record Configuration<T>(String label, T defaultValue, DataComponentType<T> component, ConfigType type, List<String> description, BiFunction<Integer, ValueEntry<?>, T> cycleValue, BiFunction<ValueEntry<?>, List<ValueEntry<?>>, Boolean> enable) {
        public static Configuration<Boolean> ofBool(String label, Boolean defaultValue, DataComponentType<Boolean> component, List<String> description, BiFunction<ValueEntry<?>, List<ValueEntry<?>>, Boolean> enable) {
            return new Configuration<Boolean>(label, defaultValue, component, ConfigType.BOOLEAN, description, null, enable);
        }

        public static enum ConfigType {
            BOOLEAN(config -> new BooleanEntry(config.label, (Boolean)config.defaultValue, config.component, config.description.toArray(new String[0]), config.enable)),
            ENUM(config -> new EnumEntry(config.label, (Enum)config.defaultValue, config.component, config.description.toArray(new String[0]), config.enable, (Configuration)config){
                final /* synthetic */ Configuration val$config;
                {
                    this.val$config = configuration;
                    super(label, value, component, comments, enable);
                }

                @Override
                protected void cycleValue(int direction) {
                    if (this.val$config.cycleValue != null) {
                        Enum value = (Enum)this.val$config.cycleValue.apply(direction, this);
                        this.setValue(value);
                        this.bumpCog((float)direction * 15.0f);
                    } else {
                        super.cycleValue(direction);
                    }
                }
            });

            private Function<Configuration<?>, ValueEntry<?>> widget;

            private ConfigType(Function<Configuration<?>, ValueEntry<?>> widget) {
                this.widget = widget;
            }

            public <B> ValueEntry<B> getWidget(Configuration<B> config) {
                return this.widget.apply(config);
            }
        }
    }

    public static enum ReachType {
        BLOCK(Attributes.BLOCK_INTERACTION_RANGE),
        ENTITY(Attributes.ENTITY_INTERACTION_RANGE),
        NONE(new Holder[0]),
        BOTH(Attributes.BLOCK_INTERACTION_RANGE, Attributes.ENTITY_INTERACTION_RANGE);

        private final List<Holder<Attribute>> attributes;

        @SafeVarargs
        private ReachType(Holder<Attribute> ... attributes) {
            this.attributes = Arrays.stream(attributes).toList();
        }

        public List<Holder<Attribute>> getAttributes() {
            return this.attributes;
        }
    }
}

