/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public class ItemTooltips {
    public static final ItemTooltips DEFAULT = ItemTooltips.createDefaultTooltips();
    private static final Codec<Object2BooleanOpenHashMap<Tooltip>> MAP_CODEC = Codec.unboundedMap(Tooltip.CODEC, (Codec)Codec.BOOL).xmap(Object2BooleanOpenHashMap::new, Function.identity());
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemTooltips> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Object2BooleanOpenHashMap::new, Tooltip.STREAM_CODEC, (StreamCodec)ByteBufCodecs.BOOL), p_340784_ -> p_340784_.tooltips, ItemTooltips::new);
    public static final Codec<ItemTooltips> CODEC = MAP_CODEC.xmap(ItemTooltips::new, t -> t.tooltips);
    final Object2BooleanOpenHashMap<Tooltip> tooltips;

    private static ItemTooltips createDefaultTooltips() {
        Object2BooleanOpenHashMap map = new Object2BooleanOpenHashMap();
        Arrays.stream(Tooltip.values()).forEach(t -> map.put((Object)t, true));
        return new ItemTooltips((Object2BooleanOpenHashMap<Tooltip>)map);
    }

    ItemTooltips(Object2BooleanOpenHashMap<Tooltip> p_341287_) {
        this.tooltips = p_341287_;
    }

    public boolean isEnable(Tooltip tooltip) {
        return this.tooltips.getBoolean((Object)tooltip);
    }

    public int size() {
        return this.tooltips.size();
    }

    public boolean isEmpty() {
        return this.tooltips.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_331697_) {
        if (this == p_331697_) {
            return true;
        }
        if (!(p_331697_ instanceof ItemTooltips)) return false;
        ItemTooltips itemenchantments = (ItemTooltips)p_331697_;
        if (!this.tooltips.equals(itemenchantments.tooltips)) return false;
        return true;
    }

    public int hashCode() {
        int i = this.tooltips.hashCode();
        return 31 * i;
    }

    public String toString() {
        return "ItemTooltips{tooltips=" + String.valueOf(this.tooltips) + "}";
    }

    public static enum Tooltip implements StringRepresentable
    {
        ENCHANTMENT("Enchantments"),
        OPTIONS("Abilities"),
        ATTRIBUTE_MODIFIERS("Attributes");

        public static final Codec<Tooltip> CODEC;
        public static final IntFunction<Tooltip> BY_ID;
        public static final StreamCodec<ByteBuf, Tooltip> STREAM_CODEC;
        private final String displayName;

        private Tooltip(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = StringRepresentable.fromValues(Tooltip::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Tooltip.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static class Mutable {
        private final Object2BooleanOpenHashMap<Tooltip> tooltips = new Object2BooleanOpenHashMap();

        public Mutable(ItemTooltips tooltips) {
            this.tooltips.putAll(tooltips.tooltips);
        }

        public void set(Tooltip tooltip, boolean enable) {
            this.tooltips.put((Object)tooltip, enable);
        }

        public boolean isEnable(Tooltip tooltip) {
            return this.tooltips.getOrDefault((Object)tooltip, true);
        }

        public ItemTooltips toImmutable() {
            return new ItemTooltips(this.tooltips);
        }
    }
}

