/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import com.simibubi.create.content.logistics.box.PackageItem;
import fr.iglee42.createqualityoflife.blockentitites.EnderPackagerBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class EnderPackagerItemHandler
implements IItemHandlerModifiable {
    private EnderPackagerBlockEntity blockEntity;

    public EnderPackagerItemHandler(EnderPackagerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.blockEntity.heldBox;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot != 0) {
            return;
        }
        this.blockEntity.heldBox = stack;
        this.blockEntity.notifyUpdate();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.insertItem(stack, simulate, false);
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate, boolean fromNetwork) {
        if (!this.blockEntity.heldBox.isEmpty()) {
            return stack;
        }
        if (!this.blockEntity.isTransmitter() && !fromNetwork) {
            return stack;
        }
        if (!this.isItemValid(0, stack)) {
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(0, stack.copyWithCount(1));
            if (!this.blockEntity.isTransmitter()) {
                this.blockEntity.receivedBox();
            } else {
                this.blockEntity.attemptToSend();
            }
        }
        return stack.copyWithCount(stack.getCount() - 1);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.blockEntity.animationTicks != 0) {
            return ItemStack.EMPTY;
        }
        ItemStack box = this.blockEntity.heldBox;
        if (!simulate) {
            this.setStackInSlot(slot, ItemStack.EMPTY);
        }
        return box;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return PackageItem.isPackage((ItemStack)stack);
    }

    public EnderPackagerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

