/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import fr.iglee42.createqualityoflife.blocks.EnderPackagerBlock;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class EnderPackagerFrequencySlot
extends ValueBoxTransform.Dual {
    Vec3 horizontal = VecHelper.voxelSpace((double)10.0, (double)5.5, (double)2.5);
    Vec3 vertical = VecHelper.voxelSpace((double)10.0, (double)2.5, (double)5.5);

    public EnderPackagerFrequencySlot(boolean first) {
        super(first);
    }

    public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)EnderPackagerBlock.FACING);
        Vec3 location = VecHelper.voxelSpace((double)8.0, (double)16.51f, (double)5.0);
        if (facing.getAxis().isHorizontal()) {
            location = VecHelper.voxelSpace((double)8.0, (double)6.0, (double)16.51f);
            if (this.isFirst()) {
                location = location.add(0.0, 0.375, 0.0);
            }
            return this.rotateHorizontally(state, location);
        }
        if (this.isFirst()) {
            location = location.add(0.0, 0.0, 0.375);
        }
        location = VecHelper.rotateCentered((Vec3)location, (double)(facing == Direction.DOWN ? 180.0 : 0.0), (Direction.Axis)Direction.Axis.X);
        return location;
    }

    public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
        float yRot;
        Direction facing = (Direction)state.getValue((Property)EnderPackagerBlock.FACING);
        float f = yRot = facing.getAxis().isVertical() ? 0.0f : AngleHelper.horizontalAngle((Direction)facing) + 180.0f;
        float xRot = facing == Direction.UP ? 90.0f : (facing == Direction.DOWN ? 270.0f : 0.0f);
        ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(yRot)).rotateXDegrees(xRot);
    }

    public float getScale() {
        return 0.4975f;
    }
}

