/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fr.iglee42.createqualityoflife.statue.Statue;
import fr.iglee42.createqualityoflife.statue.StatueModel;
import fr.iglee42.createqualityoflife.statue.StatueRenderer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class StatueCapeLayer
extends RenderLayer<Statue, StatueModel> {
    public StatueCapeLayer(RenderLayerParent<Statue, StatueModel> pRenderer) {
        super(pRenderer);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, Statue livingEntity, float limbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ItemStack itemstack;
        Optional<ResourceLocation> texture = StatueRenderer.getPlayerProfileTexture(livingEntity).map(PlayerSkin::capeTexture);
        if (texture.isPresent() && !livingEntity.isInvisible() && livingEntity.isPartShown(PlayerModelPart.CAPE) && !(itemstack = livingEntity.getItemBySlot(EquipmentSlot.CHEST)).is(Items.ELYTRA)) {
            matrixStack.pushPose();
            if (((StatueModel)this.getParentModel()).young) {
                matrixStack.translate(0.0, 0.75, 0.0);
                matrixStack.scale(0.5f, 0.5f, 0.5f);
            }
            matrixStack.translate(0.0, 0.0, 0.125);
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            float f = livingEntity.yBodyRotO + (livingEntity.yBodyRot - livingEntity.yBodyRotO);
            double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = 0.0f;
            f1 += Mth.sin((float)(Mth.lerp((float)pPartialTicks, (float)livingEntity.walkDistO, (float)livingEntity.walkDist) * 6.0f)) * 32.0f * f4;
            if (livingEntity.isCrouching()) {
                f1 += 25.0f;
            }
            matrixStack.mulPose(Axis.XP.rotationDegrees(6.0f + f2 / 2.0f + f1));
            matrixStack.mulPose(Axis.ZP.rotationDegrees(f3 / 2.0f));
            matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - f3 / 2.0f));
            VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)texture.get()));
            ((StatueModel)this.getParentModel()).renderCloak(matrixStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
            matrixStack.popPose();
        }
    }
}

