/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import fr.iglee42.createqualityoflife.utils.LogisticsNetworkExtension;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ModifyPlayerNetworkPermissionPacket
extends BlockEntityConfigurationPacket<StockManagerBlockEntity> {
    public static final StreamCodec<ByteBuf, ModifyPlayerNetworkPermissionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, p -> p.pos, (StreamCodec)UUIDUtil.STREAM_CODEC, p -> p.modifiedPlayer, NetworkPermission.STREAM_CODEC, p -> p.permission, ModifyPlayerNetworkPermissionPacket::new);
    private final UUID modifiedPlayer;
    private final NetworkPermission permission;

    public ModifyPlayerNetworkPermissionPacket(BlockPos pos, UUID modifiedPlayer, NetworkPermission permission) {
        super(pos);
        this.modifiedPlayer = modifiedPlayer;
        this.permission = permission;
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return QOLPackets.MODIFY_PERMISSION;
    }

    protected void applySettings(ServerPlayer player, StockManagerBlockEntity be) {
        LogisticsNetwork network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(be.behaviour.freqId);
        if (network != null) {
            LogisticsNetworkExtension extendedNetwork = (LogisticsNetworkExtension)network;
            NetworkPermission currentPerm = extendedNetwork.createQOL$getPlayerPermission(this.modifiedPlayer);
            if (currentPerm.equals((Object)NetworkPermission.NONE) && this.permission == NetworkPermission.MEMBER && extendedNetwork.createQOL$hasPlayerPermission((Player)player, NetworkPermission.ADMIN)) {
                ((LogisticsNetworkExtension)network).createQOL$modifyPlayerPermission(this.modifiedPlayer, this.permission);
                Create.LOGISTICS.markDirty();
            }
            if (currentPerm.equals((Object)NetworkPermission.ADMIN) && this.permission == NetworkPermission.MEMBER && player.getUUID().equals(network.owner)) {
                ((LogisticsNetworkExtension)network).createQOL$modifyPlayerPermission(this.modifiedPlayer, this.permission);
                Create.LOGISTICS.markDirty();
            }
            if (currentPerm.equals((Object)NetworkPermission.MEMBER) && this.permission == NetworkPermission.NONE && extendedNetwork.createQOL$hasPlayerPermission((Player)player, NetworkPermission.ADMIN)) {
                ((LogisticsNetworkExtension)network).createQOL$modifyPlayerPermission(this.modifiedPlayer, this.permission);
                Create.LOGISTICS.markDirty();
            }
            if (currentPerm.equals((Object)NetworkPermission.MEMBER) && this.permission == NetworkPermission.ADMIN && player.getUUID().equals(network.owner)) {
                ((LogisticsNetworkExtension)network).createQOL$modifyPlayerPermission(this.modifiedPlayer, this.permission);
                Create.LOGISTICS.markDirty();
            }
        }
    }
}

