/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import com.simibubi.create.foundation.utility.BlockHelper;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import fr.iglee42.createqualityoflife.utils.LogisticsNetworkExtension;
import fr.iglee42.createqualityoflife.utils.NetworkDestructionLevel;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DestroyLogisticsNetworkComponentPacket
extends BlockEntityConfigurationPacket<StockManagerBlockEntity> {
    public static final StreamCodec<ByteBuf, DestroyLogisticsNetworkComponentPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.pos, (StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.destroyedPos, DestroyLogisticsNetworkComponentPacket::new);
    private final BlockPos destroyedPos;

    public DestroyLogisticsNetworkComponentPacket(BlockPos pos, BlockPos destroyedPos) {
        super(pos);
        this.destroyedPos = destroyedPos;
    }

    protected void applySettings(ServerPlayer player, StockManagerBlockEntity stbe) {
        LogisticsNetwork network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(stbe.behaviour.freqId);
        if (network != null) {
            NetworkDestructionLevel level = ((LogisticsNetworkExtension)network).createQOL$getDestructionLevel();
            if (this.destroyedPos.closerThan((Vec3i)player.blockPosition(), (double)((Integer)CreateQOLConfigs.server().logistics.stockManagerMaxDestroyDistance.get()).intValue()) && level.canDestroy(network.id, (Player)player)) {
                BlockHelper.destroyBlockAs((Level)player.level(), (BlockPos)this.destroyedPos, (Player)player, (ItemStack)ItemStack.EMPTY, (float)1.0f, is -> Block.popResource((Level)player.level(), (BlockPos)this.destroyedPos, (ItemStack)is));
            }
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return QOLPackets.DESTROY_LOGISTICS_NETWORK_COMPONENT;
    }
}

