/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.mixins;

import com.mojang.serialization.DynamicOps;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import fr.iglee42.createqualityoflife.utils.LogisticsNetworkExtension;
import fr.iglee42.createqualityoflife.utils.NetworkDestructionLevel;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LogisticsNetwork.class}, remap=false)
public class LogisticsNetworkMixin
implements LogisticsNetworkExtension {
    @Unique
    private String createQOL$name = "Unnamed Network";
    @Unique
    private NetworkDestructionLevel createQOL$destructionLevel = NetworkDestructionLevel.ALL;
    @Unique
    private Map<UUID, NetworkPermission> createQOL$permissions = new HashMap<UUID, NetworkPermission>();

    @Override
    public String createQOL$getName() {
        return this.createQOL$name;
    }

    @Override
    public void createQOL$setName(String name) {
        this.createQOL$name = name;
        Create.LOGISTICS.markDirty();
    }

    @Override
    public NetworkDestructionLevel createQOL$getDestructionLevel() {
        return this.createQOL$destructionLevel;
    }

    @Override
    public void createQOL$setDestructionLevel(NetworkDestructionLevel level) {
        this.createQOL$destructionLevel = level;
        Create.LOGISTICS.markDirty();
    }

    @Override
    public Map<UUID, NetworkPermission> createQOL$getPlayersPermission() {
        return this.createQOL$permissions;
    }

    @Override
    public void createQOL$setPlayersPermission(Map<UUID, NetworkPermission> permissions) {
        this.createQOL$permissions = permissions;
        Create.LOGISTICS.markDirty();
    }

    @Inject(method={"read"}, at={@At(value="RETURN")}, cancellable=true)
    private static void createQOL$addNewFieldsToRead(CompoundTag tag, HolderLookup.Provider registries, CallbackInfoReturnable<LogisticsNetwork> cir) {
        LogisticsNetwork network = (LogisticsNetwork)cir.getReturnValue();
        if (tag.contains("Name")) {
            ((LogisticsNetworkExtension)network).createQOL$setName(tag.getString("Name"));
        }
        if (tag.contains("DestructionLevel")) {
            ((LogisticsNetworkExtension)network).createQOL$setDestructionLevel(NetworkDestructionLevel.BY_ID.apply(tag.getByte("DestructionLevel")));
        }
        if (tag.contains("Permissions")) {
            AtomicReference permissions = new AtomicReference(new HashMap());
            PERMISSIONS_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("Permissions")).result().ifPresent(permissions::set);
            ArrayList toRemove = new ArrayList();
            HashMap<UUID, NetworkPermission> newPerms = new HashMap<UUID, NetworkPermission>(permissions.get());
            newPerms.keySet().stream().filter(k -> ((NetworkPermission)((Object)((Object)newPerms.get(k)))).equals((Object)NetworkPermission.OWNER) || ((NetworkPermission)((Object)((Object)newPerms.get(k)))).equals((Object)NetworkPermission.NONE)).forEach(toRemove::add);
            toRemove.forEach(newPerms::remove);
            ((LogisticsNetworkExtension)network).createQOL$setPlayersPermission(newPerms);
        }
        cir.setReturnValue((Object)network);
    }

    @Inject(method={"write"}, at={@At(value="RETURN")}, cancellable=true)
    private void createQOL$addNewFieldsToWrite(HolderLookup.Provider registries, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        tag.putString("Name", this.createQOL$getName());
        tag.putByte("DestructionLevel", (byte)this.createQOL$getDestructionLevel().ordinal());
        PERMISSIONS_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.createQOL$getPlayersPermission()).result().ifPresent(t -> tag.put("Permissions", t));
        cir.setReturnValue((Object)tag);
    }
}

