/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.menus;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.registries.QOLMenuTypes;
import fr.iglee42.createqualityoflife.utils.LogisticsNetworkExtension;
import fr.iglee42.createqualityoflife.utils.NetworkDestructionLevel;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StockManagerMenu
extends MenuBase<StockManagerBlockEntity> {
    public boolean isAdmin;
    public boolean isOwner;
    public boolean isLocked;
    public boolean mayDestroy;
    public String name;
    public NetworkDestructionLevel destructionLevel;
    public int links;
    public Map<UUID, NetworkPermission> permissions;
    public Object screenReference;

    public StockManagerMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public StockManagerMenu(MenuType<?> type, int id, Inventory inv, StockManagerBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public static AbstractContainerMenu create(int pContainerId, Inventory pPlayerInventory, StockManagerBlockEntity stockTickerBlockEntity) {
        return new StockManagerMenu((MenuType)QOLMenuTypes.STOCK_MANAGER.get(), pContainerId, pPlayerInventory, stockTickerBlockEntity);
    }

    protected StockManagerBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        this.isAdmin = extraData.readBoolean();
        this.isOwner = extraData.readBoolean();
        this.isLocked = extraData.readBoolean();
        this.name = extraData.readUtf();
        this.links = extraData.readInt();
        this.destructionLevel = (NetworkDestructionLevel)((Object)NetworkDestructionLevel.STREAM_CODEC.decode((Object)extraData));
        this.mayDestroy = extraData.readBoolean();
        this.permissions = (Map)LogisticsNetworkExtension.PERMISSIONS_STREAM_CODEC.decode((Object)extraData);
        BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof StockManagerBlockEntity) {
            StockManagerBlockEntity stbe = (StockManagerBlockEntity)blockEntity;
            return stbe;
        }
        return null;
    }

    protected void initAndReadInventory(StockManagerBlockEntity contentHolder) {
    }

    public void initializeContents(int pStateId, List<ItemStack> pItems, ItemStack pCarried) {
    }

    protected void addSlots() {
        this.addPlayerSlots(-1000, 0);
    }

    protected void saveData(StockManagerBlockEntity contentHolder) {
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        return ItemStack.EMPTY;
    }
}

