/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.shadowsteel;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.DestroyUtils;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public class ShadowSteelShovel
extends ShovelItem
implements QOLConfigurableItem {
    public ShadowSteelShovel(Item.Properties p_42964_) {
        super((Tier)QOLTiers.SHADOW_STEEL, p_42964_);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.reach").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.REACH, (Object)true), false, true)));
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.digging").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.digging.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.DIGGING, (Object)false), false, true)));
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Digging", (Boolean)stack.getOrDefault(QOLDataComponents.DIGGING, (Object)false), QOLDataComponents.DIGGING, List.of("Activate the 3x3x3 digging when mining a block"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.digging.get()));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)true);
        }
        if (player.isCrouching()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        ShadowSteelShovel.toggleAbility(player.getItemInHand(hand), player);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.digging.get()).booleanValue()) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.digging", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        boolean enable = (Boolean)stack.getOrDefault(QOLDataComponents.DIGGING, (Object)false) == false;
        stack.set(QOLDataComponents.DIGGING, (Object)enable);
        p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.digging", new Object[0]).getString()).append(QOLConfigurableItem.chooseState(true, true, enable, false, true)).withStyle(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public static void mineBlock(BlockEvent.BreakEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.getPlayer().getMainHandItem().is((Item)QOLItems.SHADOW_STEEL_SHOVEL.get()) && !event.getPlayer().getMainHandItem().is((Item)QOLItems.SHADOW_RADIANCE_SHOVEL.get())) {
            return;
        }
        if (!((Boolean)event.getPlayer().getMainHandItem().getOrDefault(QOLDataComponents.DIGGING, (Object)false)).booleanValue()) {
            return;
        }
        if (!event.getPlayer().getMainHandItem().isCorrectToolForDrops(event.getState())) {
            return;
        }
        BlockPos startPos = event.getPos();
        Direction dir = ShadowSteelShovel.getTargetedBlockFace((ServerPlayer)event.getPlayer());
        if (dir == null) {
            return;
        }
        for (int y = 0; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offsetPos = startPos.relative(dir.getOpposite(), y);
                    if (dir.getAxis().equals((Object)Direction.Axis.Y)) {
                        offsetPos = offsetPos.offset(x, 0, z);
                    } else if (dir.getAxis().equals((Object)Direction.Axis.Z)) {
                        offsetPos = offsetPos.offset(x, z, 0);
                    } else if (dir.getAxis().equals((Object)Direction.Axis.X)) {
                        offsetPos = offsetPos.offset(0, x, z);
                    }
                    BlockState cState = event.getLevel().getBlockState(offsetPos);
                    if (!event.getPlayer().getMainHandItem().isCorrectToolForDrops(cState)) continue;
                    DestroyUtils.destroyBlock(event.getPlayer().level(), ((ServerPlayer)event.getPlayer()).gameMode.getGameModeForPlayer(), event.getPlayer(), ((ServerPlayer)event.getPlayer()).gameMode, offsetPos, event.getPos());
                }
            }
        }
    }

    public static Direction getTargetedBlockFace(ServerPlayer player) {
        double reach;
        Vec3 lookVec;
        Vec3 reachVec;
        Vec3 eyePos;
        ClipContext context;
        Level level = player.level();
        BlockHitResult hitResult = level.clip(context = new ClipContext(eyePos = player.getEyePosition(1.0f), reachVec = eyePos.add((lookVec = player.getViewVector(1.0f)).scale(reach = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE))), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            return hitResult.getDirection();
        }
        return null;
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BLOCK;
    }
}

