/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.shadowsteel;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public class ShadowSteelHoe
extends HoeItem
implements QOLConfigurableItem {
    public ShadowSteelHoe(Item.Properties p_42964_) {
        super((Tier)QOLTiers.SHADOW_STEEL, p_42964_);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.reach").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.REACH, (Object)true), false, true)));
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.ploughing").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.ploughing.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.PLOUGHING, (Object)false), false, true)));
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Ploughing", (Boolean)stack.getOrDefault(QOLDataComponents.PLOUGHING, (Object)false), QOLDataComponents.PLOUGHING, List.of("Should plough dirt in a 3x3 square"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.ploughing.get()));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)true);
        }
        if (player.isCrouching()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        ShadowSteelHoe.toggleAbility(player.getItemInHand(hand), player);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.ploughing.get()).booleanValue()) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.ploughing", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        boolean enable = (Boolean)stack.getOrDefault(QOLDataComponents.PLOUGHING, (Object)false) == false;
        stack.set(QOLDataComponents.PLOUGHING, (Object)enable);
        p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.ploughing", new Object[0]).getString()).append(QOLConfigurableItem.chooseState(true, true, enable, false, true)).withStyle(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.ploughing.get()).booleanValue() || !((Boolean)ctx.getItemInHand().getOrDefault(QOLDataComponents.PLOUGHING, (Object)false)).booleanValue()) {
            return super.useOn(ctx);
        }
        Level level = ctx.getLevel();
        BlockPos basePos = ctx.getClickedPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Pair pair;
                BlockPos blockpos = basePos.offset(x, 0, z);
                BlockState toolModifiedState = level.getBlockState(blockpos).getToolModifiedState(ctx, ItemAbilities.HOE_TILL, false);
                Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(c -> true, c -> {
                    c.getLevel().setBlock(blockpos, toolModifiedState, 11);
                    c.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)c.getPlayer(), (BlockState)toolModifiedState));
                });
                if (pair == null) continue;
                Predicate predicate = (Predicate)pair.getFirst();
                Consumer consumer = (Consumer)pair.getSecond();
                if (!predicate.test(ctx)) continue;
                Player player = ctx.getPlayer();
                level.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (level.isClientSide) continue;
                consumer.accept(ctx);
                if (player == null) continue;
                ctx.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BLOCK;
    }
}

