/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.refinedradiance;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefinedRadianceSword
extends SwordItem
implements QOLConfigurableItem {
    public RefinedRadianceSword(Item.Properties p_42964_) {
        super((Tier)QOLTiers.REFINED_RADIANCE, p_42964_);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)itemstack);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack p_41452_) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return (Integer)CreateQOLConfigs.server().equipments.tools.swordsChargeTime.get();
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity lvEntity, int remainingTime) {
        if (!(lvEntity instanceof Player)) {
            return;
        }
        Player player = (Player)lvEntity;
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.swordsAbilities.get()).booleanValue()) {
            return;
        }
        if ((Integer)CreateQOLConfigs.server().equipments.tools.swordsAirConsumption.get() > 0 && !player.isCreative()) {
            ItemStack backtank = BacktankUtil.getAllWithAir((LivingEntity)player).stream().filter(i -> BacktankUtil.getAir((ItemStack)i) >= (Integer)CreateQOLConfigs.server().equipments.tools.swordsAirConsumption.get()).findFirst().orElse(ItemStack.EMPTY);
            if (backtank.isEmpty()) {
                return;
            }
            BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)backtank, (int)((Integer)CreateQOLConfigs.server().equipments.tools.swordsAirConsumption.get()));
        }
        int usedTime = this.getUseDuration(stack, lvEntity) - remainingTime;
        float timeRatio = (float)usedTime / (float)this.getUseDuration(stack, lvEntity);
        if (!level.isClientSide) {
            Vec3 playerPos = player.position();
            double radius = (Double)CreateQOLConfigs.server().equipments.tools.swordsRadius.get();
            double strength = (Double)CreateQOLConfigs.server().equipments.tools.swordsStrength.get() * (double)timeRatio;
            AABB area = new AABB(playerPos.x - radius, playerPos.y - radius, playerPos.z - radius, playerPos.x + radius, playerPos.y + radius, playerPos.z + radius);
            List entities = level.getEntitiesOfClass(LivingEntity.class, area, entity -> entity != player && entity.isAlive());
            for (LivingEntity entity2 : entities) {
                Vec3 toPlayer = playerPos.subtract(entity2.position());
                double distance = toPlayer.length();
                if (distance <= 0.1) continue;
                double scaledStrength = distance / radius * strength;
                Vec3 direction = toPlayer.normalize().scale(scaledStrength);
                entity2.push(direction.x, 0.3, direction.z);
            }
            player.swing(InteractionHand.MAIN_HAND, true);
            player.getCooldowns().addCooldown((Item)this, ((Integer)CreateQOLConfigs.server().equipments.tools.swordsCooldowns.get()).intValue());
        } else {
            Vec3 baseMotion = new Vec3(((Double)CreateQOLConfigs.server().equipments.tools.swordsRadius.get()).doubleValue(), 0.1, 0.0);
            for (int i2 = 0; i2 < 360; i2 += 10) {
                Vec3 m = VecHelper.rotate((Vec3)baseMotion, (double)i2, (Direction.Axis)Direction.Axis.Y);
                Vec3 v = player.position().add(m.x, 0.0, m.z);
                Vec3 mo = m.normalize().scale(-0.5).add(0.0, 0.3, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.SPIT, v.x, v.y, v.z, mo.x, mo.y, mo.z);
            }
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.reach").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.REACH, (Object)true), false, true)));
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.attraction").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.cooldownState((Boolean)CreateQOLConfigs.server().equipments.tools.swordsAbilities.get(), true, (int)Math.ceil(Minecraft.getInstance().player.getCooldowns().getCooldownPercent((Item)this, 0.0f) * (float)((Integer)CreateQOLConfigs.server().equipments.tools.swordsCooldowns.get()).intValue()))));
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.ENTITY;
    }
}

