/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.armors;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLArmorMaterials;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ShadowSteelArmorItem
extends BaseArmorItem
implements QOLConfigurableItem {
    public ShadowSteelArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(QOLArmorMaterials.SHADOW_STEEL, type, properties, CreateQOL.asResource("shadow_steel"));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        if (this.getType().equals((Object)ArmorItem.Type.BOOTS)) {
            components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.diving").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.bootsDiving.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.BOOTS_DIVING, (Object)false), false, true)));
            components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.lava_walking").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.bootsLavaWalking.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.BOOTS_LAVA, (Object)true), false, true)));
        } else if (this.getType().equals((Object)ArmorItem.Type.LEGGINGS)) {
            components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.void_walk").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.voidWalking.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.VOID_WALK, (Object)true), false, true)));
        }
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ARMOR;
    }

    @Override
    public Holder<MobEffect> providedEffect(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof ArmorItem)) {
            return QOLConfigurableItem.super.providedEffect(stack);
        }
        ArmorItem it = (ArmorItem)item;
        return this.getType().equals((Object)ArmorItem.Type.BOOTS) ? MobEffects.JUMP : (this.getType().equals((Object)ArmorItem.Type.LEGGINGS) ? MobEffects.MOVEMENT_SPEED : QOLConfigurableItem.super.providedEffect(stack));
    }

    @Override
    public List<ArmorRenderType> renderTypes(ItemStack stack) {
        return Arrays.asList(ArmorRenderType.ALL, ArmorRenderType.NONE);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        if (this.getType().equals((Object)ArmorItem.Type.BOOTS)) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Diving", (Boolean)stack.getOrDefault(QOLDataComponents.BOOTS_DIVING, (Object)false), QOLDataComponents.BOOTS_DIVING, List.of("Enable diving, which makes the player descends quicker in liquids"), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.bootsDiving.get()));
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Lava Walking", (Boolean)stack.getOrDefault(QOLDataComponents.BOOTS_LAVA, (Object)true), QOLDataComponents.BOOTS_LAVA, List.of("Enable walking under lava, which makes the player walks normally under lava"), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.bootsLavaWalking.get()));
        } else if (this.getType() == ArmorItem.Type.LEGGINGS) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Void Walking", (Boolean)stack.getOrDefault(QOLDataComponents.VOID_WALK, (Object)true), QOLDataComponents.VOID_WALK, List.of("Enable walking on void"), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.voidWalking.get()));
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }
}

