/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.armors;

import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.BooleanEntry;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLArmorMaterials;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.CommonKeysHandler;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.KeyBindManager;
import fr.iglee42.createqualityoflife.utils.PreferredRender;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import fr.iglee42.createqualityoflife.utils.ShadowRadianceEffects;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShadowRadianceChestplate
extends BacktankItem.Layered
implements QOLConfigurableItem {
    private static final double FANS_ACCELERATION = 0.15;
    private static final double FANS_SPEED = 0.25;
    private static final double FANS_HOVER_SPEED = 0.2;

    public ShadowRadianceChestplate(Item.Properties properties, Supplier<BacktankItem.BacktankBlockItem> placeable) {
        super(QOLArmorMaterials.SHADOW_RADIANCE, properties, CreateQOL.asResource("shadow_radiance"), placeable);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ShadowRadianceChestplate.hasElytra(stack) && ShadowRadianceChestplate.isElytraEnable(stack) && (!ShadowRadianceChestplate.hasPropeller(stack) || !ShadowRadianceChestplate.isFansEnable(stack)) && (Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get() != false;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return true;
    }

    private static boolean hasPlayerStackInInventory(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack currentStack = player.getInventory().getItem(i);
            if (currentStack.isEmpty() || !currentStack.is(item)) continue;
            return true;
        }
        return false;
    }

    private static int getFirstInventoryIndex(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack currentStack = player.getInventory().getItem(i);
            if (currentStack.isEmpty() || !currentStack.is(item)) continue;
            return i;
        }
        return -1;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.UNBREAKING)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public void tick(ItemStack stack, Level level, Player player, int slot, boolean offHand) {
        boolean second;
        boolean bl = second = level.getGameTime() % 20L == 0L;
        if (player.isFallFlying() && ShadowRadianceChestplate.isElytraEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ((Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get()).booleanValue() && ((Boolean)CreateQOLConfigs.server().equipments.armors.elytraBoostAllowed.get()).booleanValue() && CommonKeysHandler.isHoldingUp(player)) {
            if (((Boolean)CreateQOLConfigs.server().equipments.armors.useFireworksForBoost.get()).booleanValue()) {
                if (ShadowRadianceChestplate.hasPlayerStackInInventory(player, Items.FIREWORK_ROCKET)) {
                    int rocketSlot = ShadowRadianceChestplate.getFirstInventoryIndex(player, Items.FIREWORK_ROCKET);
                    ItemStack firework = player.getInventory().getItem(rocketSlot);
                    if ((((Boolean)stack.getOrDefault(QOLDataComponents.BACKTANK_BOOST_ON_LAUNCH, (Object)false)).booleanValue() || player.getFallFlyingTicks() > 20) && player.getFallFlyingTicks() % (Integer)CreateQOLConfigs.server().equipments.armors.fireworkDuration.get() == 0 || ((Boolean)stack.getOrDefault(QOLDataComponents.BACKTANK_BOOST_ON_LAUNCH, (Object)false)).booleanValue() && player.getFallFlyingTicks() == 0) {
                        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(level, firework, (LivingEntity)player);
                        level.addFreshEntity((Entity)fireworkrocketentity);
                        player.getInventory().removeItem(rocketSlot, 1);
                    }
                }
            } else if (level.getGameTime() % 10L == 0L) {
                Vec3 vec31 = player.getLookAngle();
                double d0 = 1.5;
                double d1 = 0.1;
                Vec3 vec32 = player.getDeltaMovement();
                player.setDeltaMovement(vec32.add(vec31.x * d1 + (vec31.x * d0 - vec32.x) * 0.5, vec31.y * d1 + (vec31.y * d0 - vec32.y) * 0.5, vec31.z * d1 + (vec31.z * d0 - vec32.z) * 0.5));
                if (!player.isCreative()) {
                    BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (int)1);
                }
            }
        }
        if (player.isCreative() || player.isSpectator()) {
            return;
        }
        if (ShadowRadianceChestplate.isFansEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ShadowRadianceChestplate.hasPropeller(stack) && ((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get()).booleanValue()) {
            boolean hover = ShadowRadianceChestplate.isHoverEnable(stack) && (Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get() != false;
            boolean jumpKeyActive = CommonKeysHandler.isHoldingUp(player);
            boolean shiftKeyActive = CommonKeysHandler.isHoldingDown(player);
            player.resetFallDistance();
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).connection.aboveGroundTickCount = 0;
            }
            if (!player.isSwimming()) {
                if (jumpKeyActive) {
                    if (!hover) {
                        if (shiftKeyActive) {
                            this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, -0.0));
                        } else {
                            this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, 0.25));
                        }
                    } else if (((Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get()).booleanValue()) {
                        this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, 0.2));
                    }
                    if (second) {
                        BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (int)1);
                    }
                } else if (hover) {
                    if (((Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get()).booleanValue()) {
                        if (shiftKeyActive) {
                            this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, -0.4));
                        } else {
                            this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, -0.0));
                            if (second) {
                                BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (int)1);
                            }
                        }
                    }
                } else if (shiftKeyActive) {
                    this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, -0.4));
                } else {
                    this.pushVertically(player, Math.min(player.getDeltaMovement().get(Direction.Axis.Y) + 0.15, -0.30000000000000004));
                }
                if (CommonKeysHandler.isHoldingForwards(player)) {
                    player.moveRelative(1.0f, new Vec3(0.0, 0.0, player.isSprinting() ? 0.05625 : 0.05));
                }
                if (CommonKeysHandler.isHoldingBackwards(player)) {
                    player.moveRelative(1.0f, new Vec3(0.0, 0.0, -0.037500000000000006));
                }
                if (CommonKeysHandler.isHoldingLeft(player)) {
                    player.moveRelative(1.0f, new Vec3(0.05, 0.0, 0.0));
                }
                if (CommonKeysHandler.isHoldingRight(player)) {
                    player.moveRelative(1.0f, new Vec3(-0.05, 0.0, 0.0));
                }
            } else if (jumpKeyActive) {
                player.moveRelative(1.0f, new Vec3(0.0, 0.0, 0.05625));
                if (second) {
                    BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (int)1);
                }
            }
        }
    }

    private void pushVertically(Player p, double y) {
        Vec3 motion = p.getDeltaMovement();
        p.setDeltaMovement(motion.get(Direction.Axis.X), y, motion.get(Direction.Axis.Z));
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.air").getString()}).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.valueOf(BacktankUtil.getAir((ItemStack)stack))).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)("/" + BacktankUtil.maxAir((ItemStack)stack))).withStyle(ChatFormatting.GOLD)));
        components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.effect").getString()}).withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)((MobEffect)this.providedEffect(stack).value()).getDescriptionId()).withStyle(ChatFormatting.YELLOW)));
        components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.arms").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState(true, true, (Boolean)stack.getOrDefault(QOLDataComponents.BACKTANK_ARMS, (Object)true), false, true)));
        components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.elytra").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get(), ShadowRadianceChestplate.hasElytra(stack), ShadowRadianceChestplate.isElytraEnable(stack), true, false)));
        components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.dash").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.cooldownState((Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get(), (Boolean)stack.getOrDefault(QOLDataComponents.DASH, (Object)true), (int)Math.ceil(Minecraft.getInstance().player.getCooldowns().getCooldownPercent((Item)this, 0.0f) * (float)((Integer)CreateQOLConfigs.server().equipments.armors.dashCooldown.get()).intValue()))));
        components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.propeller").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get(), ShadowRadianceChestplate.hasPropeller(stack), true, false, false)));
        if (ShadowRadianceChestplate.hasPropeller(stack) && ((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get()).booleanValue()) {
            components.add((Component)Component.empty());
            components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.fan").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState(true, true, ShadowRadianceChestplate.isFansEnable(stack), false, true)));
            components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.hover").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get(), true, ShadowRadianceChestplate.isHoverEnable(stack), false, true)));
        }
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    public static void toggleFans(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get()).booleanValue()) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.armor.disabled", CreateQOLLang.translateDirect("ability.armor.propeller_mode", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        if (ShadowRadianceChestplate.isElytraEnable(chestplate)) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.armor.unavailable", CreateQOLLang.translateDirect("ability.armor.fan_mode", new Object[0]).getString(), CreateQOLLang.translateDirect("ability.armor.elytra_mode", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        chestplate.set(QOLDataComponents.BACKTANK_FANS, (Object)(!chestplate.has(QOLDataComponents.BACKTANK_FANS) || Boolean.FALSE.equals(chestplate.get(QOLDataComponents.BACKTANK_FANS)) ? 1 : 0));
        boolean fans = ShadowRadianceChestplate.isFansEnable(chestplate);
        p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.armor.toggle_message", CreateQOLLang.translateDirect("ability.armor.fan_mode", new Object[0]).getString()).append(QOLConfigurableItem.chooseState(true, true, fans, false, true)).withStyle(fans ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public static void toggleHover(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get()).booleanValue()) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.armor.disabled", CreateQOLLang.translateDirect("ability.armor.propeller_mode", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get()).booleanValue()) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.armor.disabled", CreateQOLLang.translateDirect("ability.armor.hover_mode", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        chestplate.set(QOLDataComponents.BACKTANK_HOVER, (Object)(chestplate.has(QOLDataComponents.BACKTANK_HOVER) && Boolean.FALSE.equals(chestplate.get(QOLDataComponents.BACKTANK_HOVER)) ? 1 : 0));
        boolean hover = ShadowRadianceChestplate.isHoverEnable(chestplate);
        p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.armor.toggle_message", CreateQOLLang.translateDirect("ability.armor.hover_mode", new Object[0]).getString()).append(QOLConfigurableItem.chooseState(true, true, hover, false, true)).withStyle(hover ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public static void toggleElytra(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get()).booleanValue()) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.armor.disabled", CreateQOLLang.translateDirect("ability.armor.elytra_mode", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        if (ShadowRadianceChestplate.isFansEnable(chestplate)) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.armor.unavailable", CreateQOLLang.translateDirect("ability.armor.elytra_mode", new Object[0]).getString(), CreateQOLLang.translateDirect("ability.armor.fan_mode", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        chestplate.set(QOLDataComponents.BACKTANK_ELYTRA_STATE, (Object)(chestplate.has(QOLDataComponents.BACKTANK_ELYTRA_STATE) && Boolean.FALSE.equals(chestplate.get(QOLDataComponents.BACKTANK_ELYTRA_STATE)) ? 1 : 0));
        boolean elytra = ShadowRadianceChestplate.isElytraEnable(chestplate);
        p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.armor.toggle_message", CreateQOLLang.translateDirect("ability.armor.elytra_mode", new Object[0]).getString()).append(QOLConfigurableItem.chooseState(true, true, elytra, false, true)).withStyle(elytra ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public static void toggleFansElytra(ItemStack chestplate, Player p) {
        boolean hasElytra = ShadowRadianceChestplate.hasElytra(chestplate);
        boolean hasPropeller = ShadowRadianceChestplate.hasPropeller(chestplate);
        if (hasElytra && hasPropeller) {
            if (!ShadowRadianceChestplate.isFansEnable(chestplate) && !ShadowRadianceChestplate.isElytraEnable(chestplate)) {
                ShadowRadianceChestplate.toggleFans(chestplate, p);
            } else if (ShadowRadianceChestplate.isElytraEnable(chestplate)) {
                ShadowRadianceChestplate.toggleElytra(chestplate, p);
                ShadowRadianceChestplate.toggleFans(chestplate, p);
            } else if (ShadowRadianceChestplate.isFansEnable(chestplate)) {
                ShadowRadianceChestplate.toggleFans(chestplate, p);
                ShadowRadianceChestplate.toggleElytra(chestplate, p);
            }
        } else if (hasElytra) {
            ShadowRadianceChestplate.toggleElytra(chestplate, p);
        } else if (hasPropeller) {
            ShadowRadianceChestplate.toggleFans(chestplate, p);
        }
    }

    public static boolean hasPropeller(ItemStack chestplate) {
        return chestplate.has(QOLDataComponents.BACKTANK_PROPELLERS) && Boolean.TRUE.equals(chestplate.get(QOLDataComponents.BACKTANK_PROPELLERS));
    }

    public static boolean hasElytra(ItemStack chestplate) {
        return chestplate.has(QOLDataComponents.BACKTANK_ELYTRA) && Boolean.TRUE.equals(chestplate.get(QOLDataComponents.BACKTANK_ELYTRA));
    }

    public static boolean isElytraEnable(ItemStack chestplate) {
        return !chestplate.has(QOLDataComponents.BACKTANK_ELYTRA_STATE) ? !ShadowRadianceChestplate.isFansEnable(chestplate) : Boolean.TRUE.equals(chestplate.get(QOLDataComponents.BACKTANK_ELYTRA_STATE));
    }

    public static boolean isFansEnable(ItemStack chestplate) {
        if (!ShadowRadianceChestplate.hasPropeller(chestplate)) {
            return false;
        }
        return !chestplate.has(QOLDataComponents.BACKTANK_FANS) || Boolean.TRUE.equals(chestplate.get(QOLDataComponents.BACKTANK_FANS));
    }

    public static boolean isHoverEnable(ItemStack chestplate) {
        if (!ShadowRadianceChestplate.hasPropeller(chestplate)) {
            return false;
        }
        return chestplate.has(QOLDataComponents.BACKTANK_HOVER) && Boolean.TRUE.equals(chestplate.get(QOLDataComponents.BACKTANK_HOVER));
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ARMOR;
    }

    @Override
    public List<ArmorRenderType> renderTypes(ItemStack stack) {
        return Arrays.stream(ArmorRenderType.values()).toList();
    }

    @Override
    public Holder<MobEffect> providedEffect(ItemStack stack) {
        return ((ShadowRadianceEffects)((Object)stack.getOrDefault(QOLDataComponents.EFFECT, (Object)ShadowRadianceEffects.REGENERATION))).getEffectHolder();
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Enable Custom Arms", (Boolean)stack.getOrDefault(QOLDataComponents.BACKTANK_ARMS, (Object)true), QOLDataComponents.BACKTANK_ARMS, Arrays.asList("Should the player's arms be replaced with the armor in first person"), (e, oe) -> true));
        list.add(QOLConfigurableItem.Configuration.ofBool("Enable Dash", (Boolean)stack.getOrDefault(QOLDataComponents.DASH, (Object)true), QOLDataComponents.DASH, List.of("Should the player dash when pressing " + KeyBindManager.DASH_KEY.getTranslatedKeyMessage().getString()), (o, oe) -> (Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get()));
        if (ShadowRadianceChestplate.hasPropeller(stack)) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Fan", (Boolean)stack.getOrDefault(QOLDataComponents.BACKTANK_FANS, (Object)true), QOLDataComponents.BACKTANK_FANS, Arrays.asList("Activate the propeller on the backtank", "_Can't be enabled if the elytra are enabled_"), (entry, oe) -> {
                boolean flag = oe.stream().noneMatch(e -> {
                    BooleanEntry oEntry;
                    return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getComponent().equals(QOLDataComponents.BACKTANK_ELYTRA_STATE) && (Boolean)oEntry.getValue() != false;
                });
                return (Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get() != false && flag;
            }));
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Hover", (Boolean)stack.getOrDefault(QOLDataComponents.BACKTANK_HOVER, (Object)false), QOLDataComponents.BACKTANK_HOVER, Arrays.asList("Activate the hover mode"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get() != false && (Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get() != false));
        }
        if (ShadowRadianceChestplate.hasElytra(stack)) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Elytra", (Boolean)stack.getOrDefault(QOLDataComponents.BACKTANK_ELYTRA_STATE, (Object)false), QOLDataComponents.BACKTANK_ELYTRA_STATE, Arrays.asList("Activate the elytra on the backtank", "_Can't be enabled if the fan is enabled_"), (entry, oe) -> {
                boolean flag = oe.stream().noneMatch(e -> {
                    BooleanEntry oEntry;
                    return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getComponent().equals(QOLDataComponents.BACKTANK_FANS) && (Boolean)oEntry.getValue() != false;
                });
                return (Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get() != false && flag;
            }));
            if (((Boolean)CreateQOLConfigs.server().equipments.armors.elytraBoostAllowed.get()).booleanValue()) {
                list.add(QOLConfigurableItem.Configuration.ofBool("Boost on Launch", (Boolean)stack.getOrDefault(QOLDataComponents.BACKTANK_BOOST_ON_LAUNCH, (Object)false), QOLDataComponents.BACKTANK_BOOST_ON_LAUNCH, Arrays.asList("Define if you should be boost when you start flying with elytra", "Works only with fireworks", "(The air boost doesn't have the same behaviour)"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get() != false && (Boolean)CreateQOLConfigs.server().equipments.armors.elytraBoostAllowed.get() != false && (Boolean)CreateQOLConfigs.server().equipments.armors.useFireworksForBoost.get() != false));
            }
        }
        list.add(new QOLConfigurableItem.Configuration<PreferredRender>("Preferred Render", (PreferredRender)((Object)stack.getOrDefault(QOLDataComponents.PREFERRED_RENDER, (Object)PreferredRender.BOTH)), QOLDataComponents.PREFERRED_RENDER, QOLConfigurableItem.Configuration.ConfigType.ENUM, Arrays.asList("Define how the additions should be rendered.", "\"Elytra\" renders only the elytra", "\"Backtank\" renders only the backtank"), (direction, entry) -> {
            PreferredRender e = (PreferredRender)((Object)((Object)entry.getValue()));
            PreferredRender[] options = (PreferredRender[])Arrays.stream(PreferredRender.values()).toArray(PreferredRender[]::new);
            e = options[Math.floorMod(e.ordinal() + direction, options.length)];
            return e;
        }, (e, oe) -> true));
        ShadowRadianceEffects[] valids = (ShadowRadianceEffects[])Arrays.stream(ShadowRadianceEffects.values()).filter(ef -> ef.isValidForItem(stack)).toArray(ShadowRadianceEffects[]::new);
        list.add(new QOLConfigurableItem.Configuration<ShadowRadianceEffects>("Effect", (ShadowRadianceEffects)((Object)stack.getOrDefault(QOLDataComponents.EFFECT, (Object)ShadowRadianceEffects.REGENERATION)), QOLDataComponents.EFFECT, QOLConfigurableItem.Configuration.ConfigType.ENUM, Arrays.asList("Define which mob effect should be provided.", "For this item, there is " + Component.translatable((String)((MobEffect)valids[0].getEffectHolder().value()).getDescriptionId()).getString() + " and " + Component.translatable((String)((MobEffect)valids[1].getEffectHolder().value()).getDescriptionId()).getString()), (direction, entry) -> {
            ShadowRadianceEffects e = (ShadowRadianceEffects)((Object)((Object)entry.getValue()));
            ShadowRadianceEffects[] options = (ShadowRadianceEffects[])Arrays.stream(ShadowRadianceEffects.values()).filter(ef -> ef.isValidForItem(stack)).toArray(ShadowRadianceEffects[]::new);
            e = options[Math.floorMod(e.ordinal() + direction, options.length)];
            return e;
        }, (e, oe) -> true));
    }

    public boolean isBarVisible(ItemStack stack) {
        return super.isBarVisible(stack) && BacktankUtil.getAir((ItemStack)stack) < BacktankUtil.maxAir((ItemStack)stack);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }
}

