/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets.entries;

import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.client.screens.itemsconfig.ItemConfigScreen;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.ValueEntry;
import fr.iglee42.createqualityoflife.packets.ChangeItemComponentPacket;
import java.util.List;
import java.util.function.BiFunction;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class BooleanEntry
extends ValueEntry<Boolean> {
    RenderElement enabled = PonderGuiTextures.ICON_CONFIRM.asStencil().withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient((GuiGraphics)ms, (float)0.0f, (int)0, (int)(height / 2), (float)height, (float)width, (Couple)AbstractSimiWidget.COLOR_SUCCESS)).at(10.0f, 0.0f);
    RenderElement disabled = PonderGuiTextures.ICON_DISABLE.asStencil().withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient((GuiGraphics)ms, (float)0.0f, (int)0, (int)(height / 2), (float)height, (float)width, (Couple)AbstractSimiWidget.COLOR_FAIL)).at(10.0f, 0.0f);
    BoxWidget button = (BoxWidget)new BoxWidget().showingElement(this.enabled).withCallback(() -> this.setValue((Boolean)this.getValue() == false));

    public BooleanEntry(String label, Boolean value, DataComponentType<Boolean> component, String[] comments, BiFunction<ValueEntry<?>, List<ValueEntry<?>>, Boolean> enable) {
        super(label, value, component, comments, enable);
        this.listeners.add(this.button);
        this.onReset();
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        this.button.active = b;
    }

    @Override
    public void tick() {
        super.tick();
        this.button.tick();
    }

    @Override
    public void render(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.render(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        this.button.setX(x + width - 80 - 28);
        this.button.setY(y + 10);
        this.button.setWidth(35);
        this.button.setHeight(height - 20);
        this.button.updateGradientFromState();
        this.button.render(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onValueChange(Boolean newValue) {
        super.onValueChange(newValue);
        this.button.showingElement(newValue != false ? this.enabled : this.disabled);
        this.bumpCog(newValue != false ? 15.0f : -16.0f);
    }

    @Override
    public void setValue(@NotNull Boolean value) {
        if (Minecraft.getInstance().screen == null) {
            CreateQOL.LOGGER.error("Cannot change component on a ValueEntry because the screen is null");
            return;
        }
        int slot = ((ItemConfigScreen)Minecraft.getInstance().screen).getItemSlot();
        PacketDistributor.sendToServer((CustomPacketPayload)new ChangeItemComponentPacket(slot, value == false ? 0 : 1, BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)this.component).toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.setValue(value);
    }
}

