/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.itemsconfig;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.foundation.gui.AllIcons;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.client.screens.itemsconfig.ItemConfigScreen;
import fr.iglee42.createqualityoflife.client.screens.widgets.ArmorConfigScreenList;
import fr.iglee42.createqualityoflife.packets.ChangeItemTooltipsPacket;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.createmod.catnip.animation.Force;
import net.createmod.catnip.animation.PhysicalFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.FadableScreenElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;

public class TooltipsConfigScreen
extends AbstractSimiScreen {
    public static final PhysicalFloat cogSpin = PhysicalFloat.create().withLimit(10.0f).withDrag(0.3).addForce((Force)new Force.Static(0.2f));
    public static DelegatedStencilElement shadowElement = new DelegatedStencilElement((graphics, x, y, alpha) -> TooltipsConfigScreen.renderCog(graphics), (graphics, x, y, alpha) -> graphics.fill(-200, -200, 200, 200, 0x60000000));
    private final ItemStack item;
    private final int itemSlot;
    protected ArmorConfigScreenList list;
    protected int listWidth;

    public TooltipsConfigScreen(int slot) {
        this.itemSlot = slot;
        this.item = Minecraft.getInstance().player.getInventory().getItem(slot);
    }

    protected void init() {
        super.init();
        this.listWidth = Math.min(this.width - 80, 300);
        int yCenter = this.height / 2;
        int listL = this.width / 2 - this.listWidth / 2;
        int listR = this.width / 2 + this.listWidth / 2;
        this.list = new ArmorConfigScreenList(this.minecraft, this.listWidth, this.height - 80, 35, 40, (Screen)this);
        this.list.setX(listL);
        this.addRenderableWidget((GuiEventListener)this.list);
        this.list.children().clear();
        BoxWidget goBack = (BoxWidget)new BoxWidget(this.width / 2 - this.listWidth / 2 - 30, this.height / 2 - 30, 20, 20).withPadding(2.0f, 2.0f).withCallback(() -> ScreenOpener.open((Screen)new ItemConfigScreen(this.itemSlot)));
        goBack.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_BACK.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(goBack)));
        goBack.getToolTip().add(Component.translatable((String)"createqol.gui.config_screen.go_back"));
        this.addRenderableWidget((GuiEventListener)goBack);
        ItemTooltips tooltips = (ItemTooltips)this.item.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT);
        for (ItemTooltips.Tooltip t : ItemTooltips.Tooltip.values()) {
            this.list.children().add(new TooltipEntry(t.getDisplayName(), tooltips.isEnable(t), t, "Disable " + t.getDisplayName() + " in the item's tooltips"));
        }
        BoxWidget enableAll = (BoxWidget)new BoxWidget(this.width / 2 + this.listWidth / 2 + 8, this.height / 2 - 45, 20, 20).withPadding(2.0f, 2.0f).withCallback(() -> this.list.children().stream().map(TooltipEntry.class::cast).forEach(e -> e.setValue(true)));
        enableAll.showingElement((RenderElement)AllIcons.I_CONFIRM.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(enableAll)));
        enableAll.getToolTip().add(Component.translatable((String)"createqol.gui.tooltips_config_screen.enable_all"));
        this.addRenderableWidget((GuiEventListener)enableAll);
        BoxWidget disableAll = (BoxWidget)new BoxWidget(this.width / 2 + this.listWidth / 2 + 8, this.height / 2 - 15, 20, 20).withPadding(2.0f, 2.0f).withCallback(() -> this.list.children().stream().map(TooltipEntry.class::cast).forEach(e -> e.setValue(false)));
        disableAll.showingElement((RenderElement)AllIcons.I_DISABLE.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(disableAll)));
        disableAll.getToolTip().add(Component.translatable((String)"createqol.gui.tooltips_config_screen.disable_all"));
        this.addRenderableWidget((GuiEventListener)disableAll);
    }

    public void tick() {
        super.tick();
        cogSpin.tick();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, -1339544524);
        shadowElement.at((float)this.width * 0.5f, (float)this.height * 0.5f, 0.0f).render(graphics);
        super.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
    }

    protected void prepareFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.minecraft.getMainRenderTarget(), (RenderTarget)UIRenderHelper.framebuffer);
        RenderSystem.clear((int)1280, (boolean)Minecraft.ON_OSX);
    }

    protected void endFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.minecraft.getMainRenderTarget());
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.width / 2;
        graphics.drawCenteredString(this.minecraft.font, (Component)Component.translatable((String)"createqol.gui.tooltips_config_screen.title", (Object[])new Object[]{this.item.getHoverName()}), x, 15, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        cogSpin.bump(3, -scrollY * 5.0);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected static void renderCog(GuiGraphics graphics) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(-100.0f, 100.0f, -100.0f);
        poseStack.scale(200.0f, 200.0f, 1.0f);
        GuiGameElement.of((BlockState)((BlockState)AllBlocks.LARGE_COGWHEEL.getDefaultState().setValue((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.Y))).rotateBlock(22.5, (double)cogSpin.getValue(partialTicks), 22.5).render(graphics);
        poseStack.popPose();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getItemSlot() {
        return this.itemSlot;
    }

    public void resize(Minecraft p_96575_, int p_96576_, int p_96577_) {
        super.resize(p_96575_, p_96576_, p_96577_);
    }

    public class TooltipEntry
    extends ArmorConfigScreenList.LabeledEntry {
        protected boolean value;
        protected List<String> commentLines;
        protected ItemTooltips.Tooltip tooltip;
        RenderElement enabled;
        RenderElement disabled;
        BoxWidget button;

        public TooltipEntry(String label, boolean value, ItemTooltips.Tooltip tooltip, String ... comments) {
            super(label);
            this.commentLines = new ArrayList<String>(List.of("."));
            this.value = value;
            this.tooltip = tooltip;
            this.labelTooltip.add(Component.literal((String)label).withStyle(ChatFormatting.WHITE));
            this.commentLines.addAll(Arrays.stream(comments).toList());
            this.labelTooltip.addAll(this.commentLines.stream().map(s -> s.equals(".") ? " " : s).map(Component::literal).flatMap(stc -> FontHelper.cutTextComponent((Component)stc, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_RED).stream()).toList());
            this.enabled = PonderGuiTextures.ICON_CONFIRM.asStencil().withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient((GuiGraphics)ms, (float)0.0f, (int)0, (int)(height / 2), (float)height, (float)width, (Couple)AbstractSimiWidget.COLOR_SUCCESS)).at(10.0f, 0.0f);
            this.disabled = PonderGuiTextures.ICON_DISABLE.asStencil().withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient((GuiGraphics)ms, (float)0.0f, (int)0, (int)(height / 2), (float)height, (float)width, (Couple)AbstractSimiWidget.COLOR_FAIL)).at(10.0f, 0.0f);
            this.button = (BoxWidget)new BoxWidget().showingElement(this.enabled).withCallback(() -> this.setValue(!this.getValue()));
            this.listeners.add(this.button);
            this.onReset();
        }

        @Override
        public void render(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            super.render(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
            this.button.setX(x + width - 80 - 28);
            this.button.setY(y + 10);
            this.button.setWidth(35);
            this.button.setHeight(height - 20);
            this.button.updateGradientFromState();
            this.button.render(graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        protected int getLabelWidth(int totalWidth) {
            return (int)((float)totalWidth * 0.4f) + 30;
        }

        public void setValue(@Nonnull boolean value) {
            this.value = value;
            this.onValueChange(value);
        }

        @Nonnull
        public boolean getValue() {
            return this.value;
        }

        public void onReset() {
            this.onValueChange(this.getValue());
        }

        public void onValueChange() {
            this.onValueChange(this.getValue());
        }

        public void onValueChange(boolean newValue) {
            this.button.showingElement(newValue ? this.enabled : this.disabled);
            this.bumpCog(newValue ? 15.0f : -16.0f);
            if (Minecraft.getInstance().screen == null) {
                CreateQOL.LOGGER.error("Cannot change component on a ValueEntry because the screen is null");
                return;
            }
            int slot = TooltipsConfigScreen.this.getItemSlot();
            PacketDistributor.sendToServer((CustomPacketPayload)new ChangeItemTooltipsPacket(slot, this.value, this.tooltip), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        protected void bumpCog() {
            this.bumpCog(10.0f);
        }

        protected void bumpCog(float force) {
            ItemConfigScreen.cogSpin.bump(3, (double)force);
        }
    }
}

