/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.itemsconfig;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fr.iglee42.createqualityoflife.client.screens.itemsconfig.ItemConfigScreen;
import fr.iglee42.createqualityoflife.client.screens.widgets.ItemConfigButton;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class InventoryConfigScreen
extends AbstractSimiScreen {
    private long scrollStartTime = System.currentTimeMillis();
    private List<Component> components = null;
    private int lastBtnIndex = -1;

    public void setDisplayedComponents(List<Component> newComponents) {
        this.components = newComponents;
        this.scrollStartTime = System.currentTimeMillis();
    }

    protected void init() {
        int finalSlot;
        int slot;
        this.setWindowOffset(-126, -98);
        super.init();
        LocalPlayer player = Minecraft.getInstance().player;
        for (slot = 0; slot < player.getInventory().items.size(); ++slot) {
            finalSlot = slot;
            if (slot < 9) {
                ItemConfigButton btn = new ItemConfigButton(this.guiLeft + slot * 28, this.guiTop + 196 + 4, b -> Minecraft.getInstance().setScreen((Screen)new ItemConfigScreen(finalSlot)), slot);
                btn = btn.showing(player.getInventory().getItem(slot));
                this.addRenderableWidget((GuiEventListener)btn);
                continue;
            }
            int row = (slot - 9) / 9;
            int col = (slot - 9) % 9;
            ItemConfigButton btn = new ItemConfigButton(this.guiLeft + col * 28, this.guiTop + 2 + (row + 4) * 28, b -> Minecraft.getInstance().setScreen((Screen)new ItemConfigScreen(finalSlot)), slot);
            btn = btn.showing(player.getInventory().getItem(slot));
            this.addRenderableWidget((GuiEventListener)btn);
        }
        for (slot = 0; slot < player.getInventory().armor.size(); ++slot) {
            finalSlot = slot;
            ItemConfigButton btn = new ItemConfigButton(this.guiLeft, this.guiTop + (3 - slot) * 28, b -> Minecraft.getInstance().setScreen((Screen)new ItemConfigScreen(finalSlot + 36)), slot + 36);
            btn = btn.showing(player.getInventory().getItem(slot + 36));
            this.addRenderableWidget((GuiEventListener)btn);
        }
        ItemConfigButton btn = new ItemConfigButton(this.guiLeft + 112 - 28, this.guiTop + 84, b -> Minecraft.getInstance().setScreen((Screen)new ItemConfigScreen(40)), 40);
        btn = btn.showing(player.getInventory().getItem(40));
        this.addRenderableWidget((GuiEventListener)btn);
        int boxWidth = this.font.width((FormattedText)Component.translatable((String)"createqol.gui.inventory_config_screen.title")) + 10;
        int boxHeight = 19;
        int boxPadding = 4;
        BoxWidget title = (BoxWidget)((BoxWidget)new BoxWidget(this.width / 2 - boxWidth / 2, this.height / 2 - 130, boxWidth, boxHeight).setActive(false)).withBorderColors(AbstractSimiWidget.COLOR_IDLE).withPadding(0.0f, (float)boxPadding).rescaleElement((float)boxWidth / 2.0f, (float)(boxHeight - 2 * boxPadding) / 2.0f);
        this.addRenderableWidget((GuiEventListener)title);
        BoxWidget infos = (BoxWidget)((BoxWidget)new BoxWidget(this.guiLeft + 140 - 28, this.guiTop, 132, 104).setActive(false)).withBorderColors(AbstractSimiWidget.COLOR_IDLE).withPadding(0.0f, (float)boxPadding);
        this.addRenderableWidget((GuiEventListener)infos);
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.children().stream().filter(c -> c instanceof ItemConfigButton).map(ItemConfigButton.class::cast).forEach(btn -> {
            btn.showing(Minecraft.getInstance().player.getInventory().getItem(btn.getIndex()));
            btn.active = Minecraft.getInstance().player.getInventory().getItem(btn.getIndex()).getItem() instanceof QOLConfigurableItem;
            btn.updateGradientFromState();
        });
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(this.guiLeft + 24), (int)(this.guiTop - 2), (int)(this.guiLeft + 106 - 24), (int)(this.guiTop + 106), (int)48, (float)0.05f, (float)mouseX, (float)mouseY, (LivingEntity)this.minecraft.player);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"createqol.gui.inventory_config_screen.title"), this.width / 2, this.height / 2 - 125, ((Color)UIRenderHelper.COLOR_TEXT_STRONG_ACCENT.getFirst()).getRGB());
        AtomicReference button = new AtomicReference();
        this.children().stream().filter(c -> c instanceof ItemConfigButton).map(ItemConfigButton.class::cast).forEach(btn -> {
            if (btn.isHovered() && btn.active) {
                button.set(btn);
            }
        });
        if (button.get() != null && this.lastBtnIndex != ((ItemConfigButton)((Object)button.get())).getIndex() && ((ItemConfigButton)((Object)button.get())).getItem() != null) {
            this.setDisplayedComponents(Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)((ItemConfigButton)((Object)button.get())).getItem()));
        }
        if (button.get() != null && ((ItemConfigButton)((Object)button.get())).getItem() != null) {
            this.renderAutoScrollingComponents(graphics, this.font, this.components, this.guiLeft + 140 - 28, this.guiTop, this.guiLeft + 140 - 28 + 132, this.guiTop + 104, this.scrollStartTime);
        }
        this.lastBtnIndex = button.get() != null ? ((ItemConfigButton)((Object)button.get())).getIndex() : -1;
    }

    public void renderAutoScrollingComponents(GuiGraphics guiGraphics, Font font, List<Component> lines, int minX, int minY, int maxX, int maxY, long scrollStartTime) {
        float offsetY;
        int maxWidth = maxX - minX;
        int clipHeight = maxY - minY;
        ArrayList wrappedLines = new ArrayList();
        for (Component comp : lines) {
            wrappedLines.addAll(font.split((FormattedText)comp, maxWidth));
        }
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int maxVisibleLines = clipHeight / lineHeight;
        long pauseStartMillis = 2000L;
        long pauseEndMillis = 2000L;
        long scrollDurationMillis = (long)wrappedLines.size() * 750L;
        long totalCycle = 2000L + scrollDurationMillis + 2000L;
        if (wrappedLines.size() <= maxVisibleLines) {
            int y = minY;
            for (FormattedCharSequence line : wrappedLines) {
                guiGraphics.drawString(font, line, minX, y, 0xFFFFFF);
                y += lineHeight;
            }
            return;
        }
        long elapsed = System.currentTimeMillis() - scrollStartTime;
        long t = elapsed % totalCycle;
        if (t < 2000L) {
            offsetY = 0.0f;
        } else if (t < 2000L + scrollDurationMillis) {
            float progress = (float)(t - 2000L) / (float)scrollDurationMillis;
            int scrollRange = (wrappedLines.size() - maxVisibleLines) * lineHeight;
            offsetY = progress * (float)scrollRange;
        } else {
            offsetY = (wrappedLines.size() - maxVisibleLines) * lineHeight;
        }
        guiGraphics.enableScissor(minX, minY, maxX, maxY);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        for (int i = 0; i < wrappedLines.size(); ++i) {
            float drawY = (float)(minY + i * lineHeight) - offsetY;
            if (drawY + (float)lineHeight < (float)minY || drawY > (float)maxY) continue;
            guiGraphics.drawString(font, (FormattedCharSequence)wrappedLines.get(i), minX, (int)drawY, 0xFFFFFF);
        }
        poseStack.popPose();
        guiGraphics.disableScissor();
    }

    public void renderBackground(GuiGraphics p_283688_, int p_296369_, int p_296477_, float p_294317_) {
    }

    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, -1339544524);
        super.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
    }

    protected void prepareFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.minecraft.getMainRenderTarget(), (RenderTarget)UIRenderHelper.framebuffer);
        RenderSystem.clear((int)1280, (boolean)Minecraft.ON_OSX);
    }

    protected void endFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.minecraft.getMainRenderTarget());
    }

    public boolean isPauseScreen() {
        return false;
    }
}

