/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blocks;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllShapes;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import com.simibubi.create.foundation.block.IBE;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.items.StockManagerBlockItem;
import fr.iglee42.createqualityoflife.registries.QOLBlockEntities;
import fr.iglee42.createqualityoflife.registries.QOLBlocks;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.utils.LogisticsNetworkExtension;
import fr.iglee42.createqualityoflife.utils.NetworkDestructionLevel;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StockManagerBlock
extends HorizontalDirectionalBlock
implements IBE<StockManagerBlockEntity>,
IWrenchable {
    public static final MapCodec<StockManagerBlock> CODEC = StockManagerBlock.simpleCodec(StockManagerBlock::new);
    public static final BooleanProperty HAS_BLAZE = BooleanProperty.create((String)"has_blaze");

    public StockManagerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_BLAZE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        boolean reverse = pContext.getPlayer() != null && pContext.getPlayer().isShiftKeyDown();
        ItemStack stack = pContext.getItemInHand();
        Item item = stack.getItem();
        BlockState defaultState = this.defaultBlockState();
        if (!(item instanceof StockManagerBlockItem)) {
            return defaultState;
        }
        return (BlockState)((BlockState)super.getStateForPlacement(pContext).setValue((Property)HAS_BLAZE, (Comparable)Boolean.valueOf(((StockManagerBlockItem)item).hasCapturedBlaze()))).setValue((Property)FACING, (Comparable)(reverse ? facing.getOpposite() : facing));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACING, HAS_BLAZE}));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof LogisticallyLinkedBlockItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, stbe -> {
            if (!stbe.behaviour.mayInteractMessage(player)) {
                return ItemInteractionResult.SUCCESS;
            }
            if (player instanceof ServerPlayer) {
                HashMap<Object, Object> permissions;
                ServerPlayer sp = (ServerPlayer)player;
                boolean showLockOption = stbe.behaviour.mayAdministrate(player) && Create.LOGISTICS.isLockable(stbe.behaviour.freqId);
                boolean isCurrentlyLocked = Create.LOGISTICS.isLocked(stbe.behaviour.freqId);
                LogisticsNetwork network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(stbe.behaviour.freqId);
                String name = network != null ? ((LogisticsNetworkExtension)network).createQOL$getName() : "Unnamed Network";
                int links = network != null ? network.totalLinks.size() : 1;
                NetworkDestructionLevel desLevel = network != null ? ((LogisticsNetworkExtension)network).createQOL$getDestructionLevel() : NetworkDestructionLevel.ALL;
                if (network != null) {
                    permissions = new HashMap<UUID, NetworkPermission>(((LogisticsNetworkExtension)network).createQOL$getPlayersPermission());
                    if (network.owner != null) {
                        permissions.put(network.owner, (Object)NetworkPermission.OWNER);
                    }
                    level.players().stream().filter(p -> !permissions.containsKey(p.getUUID())).forEach(p -> permissions.put(p.getUUID(), (Object)NetworkPermission.NONE));
                } else {
                    permissions = new HashMap();
                }
                boolean isOwner = network != null ? player.getUUID().equals(network.owner) : false;
                sp.openMenu((MenuProvider)(StockManagerBlockEntity)((Object)stbe).new StockManagerBlockEntity.StockManagerProvider(), buf -> {
                    buf.writeBoolean(showLockOption);
                    buf.writeBoolean(isOwner);
                    buf.writeBoolean(isCurrentlyLocked);
                    buf.writeUtf(name);
                    buf.writeInt(links);
                    NetworkDestructionLevel.STREAM_CODEC.encode(buf, (Object)desLevel);
                    buf.writeBoolean(desLevel.canDestroy(stbe.behaviour.freqId, player));
                    LogisticsNetworkExtension.PERMISSIONS_STREAM_CODEC.encode(buf, (Object)permissions);
                    buf.writeBlockPos(pos);
                });
            }
            return ItemInteractionResult.SUCCESS;
        });
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.STOCK_TICKER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PartialModel getHat(LevelAccessor level, BlockPos pos, LivingEntity keeper) {
        return AllPartialModels.LOGISTICS_HAT;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        IBE.onRemove((BlockState)pState, (Level)pLevel, (BlockPos)pPos, (BlockState)pNewState);
    }

    public Class<StockManagerBlockEntity> getBlockEntityClass() {
        return StockManagerBlockEntity.class;
    }

    public BlockEntityType<? extends StockManagerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)QOLBlockEntities.STOCK_MANAGER.get();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static int getLight(BlockState state) {
        boolean hasBlaze = (Boolean)state.getValue((Property)HAS_BLAZE);
        return hasBlaze ? 15 : 0;
    }

    public static LootTable.Builder buildLootTable() {
        LootItemCondition.Builder survivesExplosion = ExplosionCondition.survivesExplosion();
        StockManagerBlock block = (StockManagerBlock)((Object)QOLBlocks.STOCK_MANAGER.get());
        LootTable.Builder builder = LootTable.lootTable();
        LootPool.Builder poolBuilder = LootPool.lootPool();
        for (boolean hasBlaze : Iterate.trueAndFalse) {
            ItemLike drop = hasBlaze ? (ItemLike)QOLBlocks.STOCK_MANAGER.get() : (ItemLike)QOLItems.EMPTY_STOCK_MANAGER.get();
            poolBuilder.add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)drop).when(survivesExplosion)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)HAS_BLAZE, hasBlaze))));
        }
        builder.withPool(poolBuilder.setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)));
        return builder;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (!((Boolean)state.getValue((Property)HAS_BLAZE)).booleanValue()) {
            return null;
        }
        return super.newBlockEntity(pos, state);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, plbe -> {
            if (pPlacer instanceof Player) {
                Player player = (Player)pPlacer;
                plbe.placedBy = player.getUUID();
                plbe.notifyUpdate();
            }
        });
    }
}

